ORCA/M Asm65816 2.1.0

0001 AA00              ****************************************************************
0002 AA00              *
0003 AA00              *               Copyright (c) 1987, 1988
0004 AA00              *               Apple Computer, Inc.
0005 AA00              *               All rights reserved
0006 AA00              *
0007 AA00              ****************************************************************
0008 AA00              *
0009 AA00              *               GS/OS Bank 0 Dispatcher
0010 AA00              *
0011 AA00              *               This code resides in bank $00 location $AA00.
0012 AA00              *
0013 AA00              ****************************************************************
0014 AA00              *
0015 AA00              *               Written by: Raymond B. Montagne
0016 AA00              *
0017 AA00              ****************************************************************
0018 AA00              *
0019 AA00              * REVISION HISTORY:
0020 AA00              *
0021 AA00              * DATE     VER. BY   DESCRIPTION
0022 AA00              *
0023 AA00              * 04/07/87 0.01 RBM  Initial coding of bank 0 dispatcher
0024 AA00              *
0025 AA00              * 05/27/87 0.02 RBM  Speed selection is now based on bit 3 of the
0026 AA00              *                    slot number contained in the DIB.
0027 AA00              *
0028 AA00              * 09/25/87 0.03 RBM  UNFUTZ masks A-Reg on no error
0029 AA00              *
0030 AA00              * 10/05/87 0.04 RBM  OPEN call inits hook table for BASIC devices.
0031 AA00              *
0032 AA00              * 11/19/87 0.05 RBM  Fixed Pascal1.1 interface for startup, close,
0033 AA00              *                    flush, control & status calls.
0034 AA00              *                    Fixec Pascal1.1 interface for open call.
0035 AA00              *
0036 AA00              * 12/03/87 0.06 RBM  Relocated to $00AA00.
0037 AA00              *
0038 AA00              * 12/21/87 0.07 RBM  Fixed UNFUTZ to pass ProDOS error through.
0039 AA00              *                    Seperated dispatcher into more files.
0040 AA00              *
0041 AA00              * 01/02/88 0.08 RBM  Fixed language card dispatcher.
0042 AA00              *
0043 AA00              * 01/13/88 0.09 RBM  Fixed trash in upper byte of error code.
0044 AA00              *
0045 AA00              * 01/30/88 0.10 RBM  Translate SmartPort error codes to legitimate
0046 AA00              *                    GS/OS error codes. (see unfutz in bank0/bank0.dispatcher)
0047 AA00              *                    Language card dispatcher now preserves the state of
0048 AA00              *                    the carry flag through entry. (see lc.dispatcher)
0049 AA00              *
0050 AA00              * v0.01 a01     RBM  Alpha release.
0051 AA00              *
0052 AA00              * v0.04 a01     RBM  New release.
0053 AA00              *
0054 AA00              * v0.05 a01     RBM  New release.
0055 AA00              *
0056 AA00              * v0.05 a01     RBM  Fixed absolute reference in unfutz code to
0057 AA00              *                    a long reference.  Return from class 0 character
0058 AA00              *                    devices sometimes used wrong thread (BASIC v.s. Pascal).
0059 AA00              *
0060 AA00              * v0.05 a02     RBM  Parameter lists used by the generated driver core
0061 AA00              *                    routines to call the SmartPort interface(s) directly
0062 AA00              *                    via the bank $00 dispatcher now reside in the bank $00
0063 AA00              *                    dispatchers memory space.  This was neccessary since the
0064 AA00              *                    rom is enabled during firmware calls making parameters
0065 AA00              *                    in the device dispatcher's address space inaccessable
0066 AA00              *                    to the SmartPort interface being called.
0067 AA00              *
0068 AA00              * v0.06 a01     RBM  New release.
0069 AA00              *
0070 AA00              * v0.07 a01     RBM  New release.
0071 AA00              *
0072 AA00              * v0.08 a01     RBM  Class 0 character devices now use highest level
0073 AA00              *                    interface available and is not selectable.  This
0074 AA00              *                    means that Pascal devices cannot be configured
0075 AA00              *                    to use the BASIC interface.
0076 AA00              *
0077 AA00              * v0.08 a02     RBM  Preserve interrupt enable status across the dispatch
0078 AA00              *                    to a firmware interface.
0079 AA00              *
0080 AA00              * v0.08 a03     RBM  Rearranged how interrupt status is preserved so that
0081 AA00              *                    SmartPort soft error codes are not lost.
0082 AA00              *
0083 AA00              * v0.08 a04     RBM  During counting of generated driver, always exit as
0084 AA00              *                    if class 1 or class 2 device.
0085 AA00              *
0086 AA00              * v0.09 a01     RBM  Class 1 and class 2 soft errors are filtered out.
0087 AA00              *
0088 AA00              * v0.09 a02     RBM  Well, they almost were.  Reference needed to be
0089 AA00              *                    long when checking exit type during unfutz.
0090 AA00              *
0091 AA00              * v0.09 a03     RBM  Select bank $00 before calling a card.
0092 AA00              *
0093 AA00              * v0.10 a02     RBM  Added a bank $00 resident routine to determine the
0094 AA00              *                    machine rom version number.
0095 AA00              *
0096 AA00              * v0.16 b01     GRT  fixed external slot bit problem in basic_type found in
0097 AA00              *                    bank0/bank0.dispatch
0098 AA00              *
0099 AA00              * v0.16 b01     GRT  fixed external slot bit problem in UNFUTZ found in
0100 AA00              *                    bank0/bank0.dispatch and BIT problem with c0_flag
0101 AA00              *
0102 AA00              * v0.16 b02     GRT  added code to make sure drvr_blk_num+2 is zero for
0103 AA00              *                    prodos block devices
0104 AA00              *                    new label in bank0.dispatch is "pro_blk_bad"
0105 AA00              *
0106 AA00              * v04.10 a01    RBM     General code reduction.  Added main entry for slot
0107 AA00              *                       arbiter to preserve the rom state (statereg bit 3)
0108 AA00              *                       and switch in RAM prior to dispatching to the
0109 AA00              *                       slot arbiter core routine resident in the language 
0110 AA00              *                       card adjacent to the device manager.  Added parameter
0111 AA00              *                       lists to be used with the bank 0 core dispatcher so
0112 AA00              *                       that standard and extended SmartPort DIB status calls
0113 AA00              *                       may be issued by the driver core routines resident in
0114 AA00              *                       the device dispatcher.
0115 AA00              *
0116 AA00              * v4.10 d9      RBM     Reduce os overhead in language card dispatcher.
0117 AA00              *                       Set system speed eliminates unneccessary calls through
0118 AA00              *                       the language card dispatcher.
0119 AA00              *
0120 AA00              * v4.10 d10     RBM     Removed intermediate layer for language card dispatching
0121 AA00              *                       to language card resident system service call routines now
0122 AA00              *                       resident in fast managed memory.
0123 AA00              *
0124 AA00              * v4.10 d11     RBM     ProDOS calls are not pre parsed for block out of range.
0125 AA00              *                       This responsibility is passed on to the target firmware
0126 AA00              *                       interface.
0127 AA00              *
0128 AA00              * v4.10 d14     RBM     Fixed UniDisk3.5 access for block size $020C.
0129 AA00              *
0130 AA00              * 11/13/91      GAB     Fixed Pascal Protocol handler so that a character read
0131 AA00              *                         from the Pascal firmware will ALWAYS be returned in
0132 AA00              *                         the accumulator.
0133 AA00              *                       Replaced all BRL opcodes with JMP opcodes, since this
0134 AA00              *                         code resides at an absolute location in memory and is
0135 AA00              *                         always loaded as a binary image.
0136 AA00              *
0137 AA00              * 11/21/91      GAB     Fixed SmartPort error code translation.  A SmartPort
0138 AA00              *                         error code of $11 (bad unit number) used to get
0139 AA00              *                         translated into a $22 (bad parameter) GS/OS error
0140 AA00              *                         code.  I've changed this so it's translated into
0141 AA00              *                         GS/OS error $28 (no device connected).
0142 AA00              *
0143 AA00              ****************************************************************
0144 AA00
0145 AA00                       eject 
0146 AA00              ;-----------------------------------------------
0147 AA00              ;
0148 AA00              ;   Forward addresses and entries
0149 AA00              ;
0150 AA00              ;-----------------------------------------------
0151 AA00
0152 AA00                       entry dispatcher
0153 AA00                       entry esp_ctrl_trans
0154 AA00                       entry esp_stat_trans
0155 AA00                       entry ext_dev_stat
0156 AA00                       entry ext_eject
0157 AA00                       entry ext_format
0158 AA00                       entry ext_reset
0159 AA00                       entry ext_set_dcb
0160 AA00                       entry fw_return
0161 AA00                       entry g_fmt_pcnt
0162 AA00                       entry lc_jump_addr
0163 AA00                       entry parm_list_ptr
0164 AA00                       entry pro_trans
0165 AA00                       entry set_fmt_p
0166 AA00                       entry set_reg
0167 AA00                       entry set_sp_command
0168 AA00                       entry sp_close
0169 AA00                       entry sp_command
0170 AA00                       entry sp_control
0171 AA00                       entry sp_ctrl_trans
0172 AA00                       entry sp_flush
0173 AA00                       entry sp_open
0174 AA00                       entry sp_read
0175 AA00                       entry sp_shut_dn
0176 AA00                       entry sp_start_up
0177 AA00                       entry sp_stat_trans
0178 AA00                       entry sp_status
0179 AA00                       entry sp_translate
0180 AA00                       entry sp_write
0181 AA00                       entry std_dev_stat
0182 AA00                       entry std_eject
0183 AA00                       entry std_format
0184 AA00                       entry std_reset
0185 AA00                       entry std_set_dcb
0186 AA00                       entry sys_buffer
0187 AA00                       entry b0_get_dev_char
0188 AA00                       entry set_move_cnt
0189 AA00
0190 AA00                       Print Off
0191 AA00                       include 'common.equ.src' 
0192 AA00                       include 'hw.equ.src' 
0193 AA00                       include 'driver.equ.src' 
0194 AA00                       Print On
0195 AA00
0196 AA00                       EJECT 
0197 AA00              *****************************************************************
0198 AA00              *
0199 AA00              * SYSTEM I/O BUFFER:
0200 AA00              *
0201 AA00              *****************************************************************
0202 AA00                       export the_sys_buffer
0203 AA00              the_sys_buffer proc 
0204 AA00                       export sys_buffer
0205 AA00              sys_buffer                              ; system buffer is at beginning
0206 AA00
0207 AA00 00 00 00 00           DS B:$020C                     ; system buffer is 524 bytes long
0208 AC0C
0209 AC0C                       endp 
0210 AC0C                       EJECT 
0211 AC0C              ****************************************************************
0212 AC0C              *
0213 AC0C              * This code segment is the bank 0 dispatcher for generated
0214 AC0C              * drivers running under the GS/OS.  This routine must reside
0215 AC0C              * in bank 0 and performs the switch to emulation mode prior
0216 AC0C              * to calling a slot resident firmware based device driver.
0217 AC0C              *
0218 AC0C              * ENTRY:        A = Call Number
0219 AC0C              *               X = Input character
0220 AC0C              *               Y = Undefined
0221 AC0C              *               D = GS/OS direct page
0222 AC0C              *               B = Undefined
0223 AC0C              *               S = Native mode stack
0224 AC0C              *               P = 0=m=x=e
0225 AC0C              *               Transfer count must be set to current
0226 AC0C              *               count as the transfer count will be
0227 AC0C              *               adjusted by this routine
0228 AC0C              *
0229 AC0C              *               NOTE: At entry, the portion of the bank 0 dispatcher not
0230 AC0C              *               resident in bank 0 is responsible for setting up the
0231 AC0C              *               parameter inputs on the direct page workspace for the device
0232 AC0C              *               being called.
0233 AC0C              *
0234 AC0C              * EXIT:         A = Error Code or Output Character
0235 AC0C              *               X = X & Y from emulation dispatch
0236 AC0C              *                   8 bit X in low byte of 16 bit X register
0237 AC0C              *                   8 bit Y in high byte of 16 bit X register 
0238 AC0C              *               Y = Unchanged
0239 AC0C              *               D = GS/OS direct page
0240 AC0C              *               B = Unchanged
0241 AC0C              *               S = Native mode stack
0242 AC0C              *               P = 0=m=x=e (c=1 if error, else 0)
0243 AC0C              *
0244 AC0C              ****************************************************************
0245 AC0C                       export b0dsptch
0246 AC0C              b0dsptch proc 
0247 AC0C                       export bank0_dsptch
0248 AC0C              bank0_dsptch  
0249 AC0C 4C 75 AC              jmp   dispatcher               ; data area follows entry point
0250 AC0F
0251 AC0F                       endp 
0252 AC0F
0253 AC0F              ***************************************************************
0254 AC0F              *
0255 AC0F              * The following is a pointer to the data area to be used for
0256 AC0F              * setting up a SmartPort parameter list
0257 AC0F              *
0258 AC0F              ***************************************************************
0259 AC0F                       export param_list
0260 AC0F              param_list proc 
0261 AC0F                       export call_list_ptr
0262 AC0F              call_list_ptr  
0263 AC0F 16 AE                 DC W:sp_command
0264 AC11
0265 AC11                       endp 
0266 AC11                       EJECT 
0267 AC11              ***************************************************************
0268 AC11              *
0269 AC11              * This following variables are used to set the default number
0270 AC11              * of devices per slot for ProDOS block device cards.  This is
0271 AC11              * done to prevent ghost device drivers for devices interfaced
0272 AC11              * through the ProDOS block device protocol that may not exist
0273 AC11              * 
0274 AC11              *  ___ ___ ___ ___ ___ ___ ___ ___
0275 AC11              * |   |   |   |   |   |   |   |   |
0276 AC11              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 | Internal Slots
0277 AC11              * |___|___|___|___|___|___|___|___|
0278 AC11              *   |   |   |   |   |   |   |   |___ 1=Nonconfigured, 0=Configured
0279 AC11              *   |   |   |   |   |   |   |_______ Slot #1  -  0=1 device, 1=2 devices
0280 AC11              *   |   |   |   |   |   |___________ Slot #2  -  0=1 device, 1=2 devices
0281 AC11              *   |   |   |   |   |_______________ Slot #3  -  0=1 device, 1=2 devices
0282 AC11              *   |   |   |   |___________________ Slot #4  -  0=1 device, 1=2 devices
0283 AC11              *   |   |   |_______________________ Slot #5  -  0=1 device, 1=2 devices
0284 AC11              *   |   |___________________________ Slot #6  -  0=1 device, 1=2 devices
0285 AC11              *   |_______________________________ Slot #7  -  0=1 device, 1=2 devices
0286 AC11              *  ___ ___ ___ ___ ___ ___ ___ ___
0287 AC11              * |   |   |   |   |   |   |   |   |
0288 AC11              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 | External Slots
0289 AC11              * |___|___|___|___|___|___|___|___|
0290 AC11              *   |   |   |   |   |   |   |   |___ 1=Nonconfigured, 0=Configured
0291 AC11              *   |   |   |   |   |   |   |_______ Slot #9  -  0=1 device, 1=2 devices
0292 AC11              *   |   |   |   |   |   |___________ Slot #10 -  0=1 device, 1=2 devices
0293 AC11              *   |   |   |   |   |_______________ Slot #11 -  0=1 device, 1=2 devices
0294 AC11              *   |   |   |   |___________________ Slot #12 -  0=1 device, 1=2 devices
0295 AC11              *   |   |   |_______________________ Slot #13 -  0=1 device, 1=2 devices
0296 AC11              *   |   |___________________________ Slot #14 -  0=1 device, 1=2 devices
0297 AC11              *   |_______________________________ Slot #15 -  0=1 device, 1=2 devices
0298 AC11              *
0299 AC11              ***************************************************************
0300 AC11                       export prodos_config
0301 AC11              prodos_config proc 
0302 AC11                       export config_ram
0303 AC11              config_ram  
0304 AC11 FF                    DC B:$00                       ; all 1 device and not configured
0305 AC12 FF                    DC B:$00                       ; all 1 device and not configured
0306 AC13
0307 AC13                       export c0_flag
0308 AC13              c0_flag   
0309 AC13 FF 00                 DC W:0
0310 AC15
0311 AC15                       endp 
0312 AC15                       EJECT 
0313 AC15              ***************************************************************
0314 AC15              *
0315 AC15              * The following variables apply to the bank 0 dispatcher only.
0316 AC15              * There was no room available for them on direct page.
0317 AC15              *
0318 AC15              ***************************************************************
0319 AC15                       export dsptch_vars
0320 AC15              dsptch_vars proc 
0321 AC15                       export b0_buff_ptr
0322 AC15 00 00 00 00  b0_buff_ptr DS B:4                      ; (lw) Bank0 dispatcher buffer pointer
0323 AC19                       export b0_blk_num
0324 AC19 00 00 00 00  b0_blk_num DS B:4                       ; (lw) Bank0 dispatcher block number
0325 AC1D                       export param_list_ptr
0326 AC1D              param_list_ptr  
0327 AC1D                       export parm_list
0328 AC1D 03 02 00 AA  parm_list DS B:12                       ; (12) Parameter list class 1 & 2
0329 AC29              ;                                       ; (b)  Parameter count
0330 AC29              ;                                       ; (b)  Unit Number
0331 AC29              ;                                       ; (lw) Buffer Pointer
0332 AC29              ;                                       ; (lw) Block Address
0333 AC29                       export b0_temp
0334 AC29 32 00        b0_temp  DS B:2                         ; (w)  Temporary storage
0335 AC2B                       export d_class
0336 AC2B 00           d_class  DS B:1                         ; (b)  Driver class
0337 AC2C                       export save_sp
0338 AC2C A7 BF        save_sp  DS B:2                         ; (w)  native stack pointer
0339 AC2E                       export a_reg
0340 AC2E 00           a_reg    DS B:1                         ; (b)  Accumulator on dispatch
0341 AC2F                       export block_cnt
0342 AC2F 00 00 00 00  block_cnt DS B:4                        ; (lw) block counter
0343 AC33                       export block_num
0344 AC33 00 00 00 00  block_num DS B:4                        ; (lw) block number for current read
0345 AC37
0346 AC37                       eject 
0347 AC37              *****************************************************************
0348 AC37              *
0349 AC37              * The following parameter lists are used by the generated
0350 AC37              * driver core routines when calling a SmartPort interface
0351 AC37              * via the bank $00 core routines.
0352 AC37              *
0353 AC37              *****************************************************************
0354 AC37                       export get_fmt_list
0355 AC37 4B           get_fmt_list DC B:$4B                   ; get format options call
0356 AC38 3C AC 00 00           DC L:g_fmt_pcnt                ; pointer to SmartPort parameter list
0357 AC3C                       export g_fmt_pcnt
0358 AC3C 03           g_fmt_pcnt DC B:3                       ; 3 parameters
0359 AC3D                       export get_fmt_unit
0360 AC3D 00           get_fmt_unit DC B:0                     ; unit number (from DIB)
0361 AC3E                       export get_fmt_slist
0362 AC3E 00 00 00 00  get_fmt_slist DC L:0                    ; pointer to status list
0363 AC42                       export get_fmt_reqcnt
0364 AC42 00 00        get_fmt_reqcnt DC W:0                   ; request count
0365 AC44
0366 AC44                       export set_fmt_list
0367 AC44 4A           set_fmt_list DC B:$4A                   ; command
0368 AC45 49 AC 00 00           DC L:set_fmt_p                 ; pointer to parameter list
0369 AC49                       export set_fmt_p
0370 AC49 03           set_fmt_p DC B:3                        ; parameter count
0371 AC4A                       export set_fmt_unit
0372 AC4A 00           set_fmt_unit DC B:0                     ; unit number
0373 AC4B                       export set_fmt_clist
0374 AC4B 00 00 00 00  set_fmt_clist DC L:0                    ; control list pointer
0375 AC4F                       export set_fmt_req
0376 AC4F 00 00        set_fmt_req DC W:0                      ; request count
0377 AC51
0378 AC51                       export sp_stat3
0379 AC51 00           sp_stat3 DC B:$00                       ; command
0380 AC52 54 AC                 DC W:sp_stat3_p                ; pointer to parameter list
0381 AC54                       export sp_stat3_p
0382 AC54 03           sp_stat3_p DC B:3                       ; parameter count
0383 AC55 00                    DC B:0                         ; unit number
0384 AC56 00 AA 00 00           DC L:sys_buffer                ; status list pointer
0385 AC5A 03                    DC B:3                         ; status code
0386 AC5B
0387 AC5B                       export esp_stat3
0388 AC5B 40           esp_stat3 DC B:$40                      ; command
0389 AC5C 60 AC 00 00           DC L:esp_stat3_p               ; pointer to parameter list
0390 AC60                       export esp_stat3_p
0391 AC60 03           esp_stat3_p DC B:3                      ; parameter count
0392 AC61 00                    DC B:0                         ; unit number
0393 AC62 00 AA 00 00           DC L:sys_buffer                ; status list pointer
0394 AC66 03                    DC B:3                         ; status code
0395 AC67
0396 AC67                       endp 
0397 AC67                       eject 
0398 AC67              *
0399 AC67              * The following is a hook table maintained for BASIC device drivers.
0400 AC67              * This table is intialized by the DRVR_STARTUP call.
0401 AC67              *
0402 AC67                       export hook_table
0403 AC67              hook_table proc 
0404 AC67 05                    DC B:$05                       ; slot 1 BASIC input entry point
0405 AC68 07                    DC B:$07                       ; slot 1 BASIC output entry point
0406 AC69 05                    DC B:$05                       ; slot 2 BASIC input entry point
0407 AC6A 07                    DC B:$07                       ; slot 2 BASIC output entry point
0408 AC6B 05                    DC B:$05                       ; slot 3 BASIC input entry point
0409 AC6C 07                    DC B:$07                       ; slot 3 BASIC output entry point
0410 AC6D 05                    DC B:$05                       ; slot 4 BASIC input entry point
0411 AC6E 07                    DC B:$07                       ; slot 4 BASIC output entry point
0412 AC6F 05                    DC B:$05                       ; slot 5 BASIC input entry point
0413 AC70 07                    DC B:$07                       ; slot 5 BASIC output entry point
0414 AC71 05                    DC B:$05                       ; slot 6 BASIC input entry point
0415 AC72 07                    DC B:$07                       ; slot 6 BASIC output entry point
0416 AC73 05                    DC B:$05                       ; slot 7 BASIC input entry point
0417 AC74 07                    DC B:$07                       ; slot 7 BASIC output entry point
0418 AC75
0419 AC75                       endp 
0420 AC75                       EJECT 
0421 AC75              ****************************************************************
0422 AC75              *
0423 AC75              * This code segment is the bank 0 dispatcher for generated
0424 AC75              * drivers running under the GS/OS.  This routine must reside
0425 AC75              * in bank 0 and performs the switch to emulation mode prior
0426 AC75              * to calling a slot resident firmware based device driver.
0427 AC75              *
0428 AC75              * ENTRY:        A = Call Number
0429 AC75              *               X = Input character
0430 AC75              *               Y = Undefined
0431 AC75              *               D = GS/OS direct page
0432 AC75              *               B = Undefined
0433 AC75              *               S = Native mode stack
0434 AC75              *               P = 0=m=x=e
0435 AC75              *               Transfer count must be set to current
0436 AC75              *               count as the transfer count will be
0437 AC75              *               adjusted by this routine
0438 AC75              *
0439 AC75              *               NOTE: At entry, the portion of the bank 0 dispatcher not
0440 AC75              *               resident in bank 0 is responsible for setting up the
0441 AC75              *               parameter inputs on the direct page workspace for the device
0442 AC75              *               being called.
0443 AC75              *
0444 AC75              * EXIT:         A = Error Code or Output Character
0445 AC75              *               X = X & Y from emulation dispatch
0446 AC75              *                   8 bit X in low byte of 16 bit X register
0447 AC75              *                   8 bit Y in high byte of 16 bit X register 
0448 AC75              *               Y = Unchanged
0449 AC75              *               D = GS/OS direct page
0450 AC75              *               B = Unchanged
0451 AC75              *               S = Native mode stack
0452 AC75              *               P = 0=m=x=e (c=1 if error, else 0)
0453 AC75              *
0454 AC75              ****************************************************************
0455 AC75                       export dispatcher
0456 AC75              dispatcher proc 
0457 AC75                       longa on
0458 AC75                       longi on
0459 AC75
0460 AC75              *
0461 AC75              * This routine sets the stack pointer to page 1 in preparation
0462 AC75              * for switching to emulation mode.
0463 AC75              *
0464 AC75 A8                    tay                            ; save A Reg input
0465 AC76 3B                    tsc                            ; save native sp
0466 AC77 8F 2C AC 00           sta   >save_sp
0467 AC7B E2 20                 sep   #$20                     ; 8 bit 'm'
0468 AC7D                       longa off
0469 AC7D
0470 AC7D EB                    xba                            ; get stack page in A
0471 AC7E 3A                    dec   a                        ; is stack in page 1?
0472 AC7F F0 08                 beq   pg1                      ; yes
0473 AC81 A9 01                 lda   #$01                     ; if not, set page 1
0474 AC83 EB                    xba   
0475 AC84 AF 00 01 01           lda   >emulstack               ; get emulation mode stack pointer
0476 AC88 1B                    tcs                            ; to set page 1 stack pointer
0477 AC89
0478 AC89              *
0479 AC89              * Stack pointer is now set to emulation mode stack.  Need to preserve the
0480 AC89              * device driver data bank prior to dispatching.  Will assume a worse case
0481 AC89              * dispatch of class 3 and store 5 NOP instructions following the return
0482 AC89              * address.  If not type 2, return from firmware driver will fall through
0483 AC89              * the NOP with minimal impact on execution time.  This allows one single
0484 AC89              * bank 0 dispatcher to be used for all generated drivers.
0485 AC89              *
0486 AC89              pg1       
0487 AC89 8B                    phb                            ; save environment
0488 AC8A 0B                    phd   
0489 AC8B 4B                    phk                            ; data bank must be $00 for firmware
0490 AC8C AB                    plb   
0491 AC8D 8C 2E AC              sty   |a_reg                   ; A reg for firmware
0492 AC90 A9 EA                 lda   #$EA                     ; must lay down the 5 nop's
0493 AC92 A2 04 00              ldx   #$0004
0494 AC95              noploop   
0495 AC95 9D 16 AE              sta   |fw_return,x
0496 AC98 CA                    dex   
0497 AC99 10 FA                 bpl   noploop
0498 AC9B
0499 AC9B              *
0500 AC9B              * Not in emulation mode yet.  Direct page is to GS/OS direct page for
0501 AC9B              * indirect access of rom locations internal to the firmware driver to
0502 AC9B              * be called.  This is needed to locate the entry points within the
0503 AC9B              * firmware driver so that the dispatch to the proper entry point can
0504 AC9B              * be made.
0505 AC9B              *
0506 AC9B 64 28                 stz   <fw_addr
0507 AC9D A0 2E 00              ldy   #slot_num                ; slot where fw resides
0508 ACA0 B7 20                 lda   [<drvr_dib_ptr],y
0509 ACA2 29 07                 and   #$07                     ; slots 1 through 7 are valid
0510 ACA4 09 C0                 ora   #$C0                     ; make $Cn
0511 ACA6 85 29                 sta   <fw_addr+1               ; and save for $CnXX
0512 ACA8 64 2A                 stz   <fw_addr+2
0513 ACAA A0 40 00              ldy   #drvr_class              ; get this driver's class
0514 ACAD B7 20                 lda   [<drvr_dib_ptr],y
0515 ACAF 85 2B                 sta   <d_class                 ; save for easier access
0516 ACB1 29 3F                 and   #$3F                     ; mask character device flag
0517 ACB3 F0 03                 beq   class0                   ; if a class 0 call
0518 ACB5 4C 76 AD              jmp   not_class0               ; if not a class 0 device
0519 ACB8
0520 ACB8              *
0521 ACB8              * Got here if either a ProDOS block device or a character device such
0522 ACB8              * as BASIC or Pacal1.1.  Must determine if character device to avoid
0523 ACB8              * setting up absolute zero page parameters for a ProDOS block device.
0524 ACB8              *
0525 ACB8              class0    
0526 ACB8                       longa off
0527 ACB8                       longi on
0528 ACB8 24 2B                 bit   <d_class                 ; character device?
0529 ACBA 30 49                 bmi   char_dev                 ; yes
0530 ACBC
0531 ACBC              *
0532 ACBC              * It is a ProDOS block device if got here.  Must set up call parameters
0533 ACBC              * on absolute zero page.  Also must determine the ProDOS block device
0534 ACBC              * entry point as follows:
0535 ACBC              *
0536 ACBC              *               ($CnFF) + $Cn00 = ProDOS entry point
0537 ACBC              *
0538 ACBC              prodos    
0539 ACBC                       longa off
0540 ACBC                       longi on
0541 ACBC
0542 ACBC A0 FF 00              ldy   #$00FF                   ; get ProDOS block entry point
0543 ACBF B1 28                 lda   (<fw_addr),y
0544 ACC1 85 28                 sta   <fw_addr
0545 ACC3              *
0546 ACC3              * ProDOS unit number is constructed from DIB unit and slot.
0547 ACC3              *
0548 ACC3 A0 30 00              ldy   #unit_num                ; create ProDOS Unit Number
0549 ACC6 B7 20                 lda   [<drvr_dib_ptr],y
0550 ACC8 3A                    dec   a
0551 ACC9 4A                    lsr   a                        ; carry is now unit number
0552 ACCA 08                    php   
0553 ACCB A0 2E 00              ldy   #slot_num
0554 ACCE B7 20                 lda   [<drvr_dib_ptr],y
0555 ACD0 20 0C AF              jsr   a_times_16
0556 ACD3 0A                    asl   a
0557 ACD4 28                    plp   
0558 ACD5 6A                    ror   a
0559 ACD6 8F 43 00 00           sta   >punit                   ; ProDOS unit number
0560 ACDA              *
0561 ACDA              * Translate GS/OS driver call number to ProDOS call number
0562 ACDA              * and set for dispatch to device.
0563 ACDA              *
0564 ACDA A6 02                 ldx   <drvr_call_num
0565 ACDC BD 03 B1              lda   |pro_trans,x
0566 ACDF 8F 42 00 00           sta   >pcmd
0567 ACE3              *
0568 ACE3              * Set up ProDOS block device call parameters for the
0569 ACE3              * buffer address and block address.
0570 ACE3              *
0571 ACE3 C2 20                 rep   #$20                     ; 16 bit 'm'
0572 ACE5                       longa on
0573 ACE5 A5 04                 lda   <drvr_buf_ptr            ; set ProDOS buffer pointer
0574 ACE7 8D 44 00              sta   |pbuffer
0575 ACEA A5 10                 lda   <drvr_blk_num            ; set ProDOS block number
0576 ACEC 8D 46 00              sta   |pblock
0577 ACEF A5 12                 lda   <drvr_blk_num+2          ; check buffer in range
0578 ACF1 F0 0D                 beq   prodos_ok
0579 ACF3
0580 ACF3              prodos_error  
0581 ACF3 A2 2D 00              ldx   #drvr_bad_block          ; flag bad block error
0582 ACF6 38                    sec   
0583 ACF7 2B                    pld                            ; restore native environment
0584 ACF8 AB                    plb   
0585 ACF9 AF 2C AC 00           lda   >save_sp
0586 ACFD 1B                    tcs   
0587 ACFE 8A                    txa                            ; error code must be in A Reg
0588 ACFF 6B                    rtl   
0589 AD00
0590 AD00              prodos_ok  
0591 AD00 E2 20                 sep   #$20                     ; 8 bit 'm'
0592 AD02                       longa off
0593 AD02 4C DE AD              jmp   set_reg                  ; ready for dispatch
0594 AD05
0595 AD05              *
0596 AD05              * It is either a BASIC or Pascal1.1 character device if got here.
0597 AD05              * Must determine which type it is using the Pascal1.1 firmware
0598 AD05              * signature bytes as follows:
0599 AD05              *
0600 AD05              *               $Cn05 = $38 (standard)
0601 AD05              *               $Cn07 = $18 (standard)
0602 AD05              *               $Cn0B = $01 (generic signature of firmware cards)
0603 AD05              *
0604 AD05              char_dev  
0605 AD05                       longa off
0606 AD05                       longi on
0607 AD05
0608 AD05 E2 10                 sep   #$10                     ; 8 bit 'x'
0609 AD07                       longi off
0610 AD07
0611 AD07 A9 FF                 lda   #$FF                     ; assume its a Pascal1.1 device
0612 AD09 8D 13 AC              sta   |c0_flag
0613 AD0C
0614 AD0C A0 05                 ldy   #$05
0615 AD0E B7 28                 lda   [<fw_addr],y             ; $Cn05 = $38 if Pascal1.1
0616 AD10 C9 38                 cmp   #$38
0617 AD12 D0 0F                 bne   basic_type               ; if not Pascal1.1
0618 AD14 C8                    iny   
0619 AD15 C8                    iny   
0620 AD16 B7 28                 lda   [<fw_addr],y             ; $Cn07 = $18 if Pascal1.1
0621 AD18 C9 18                 cmp   #$18
0622 AD1A D0 07                 bne   basic_type               ; if not Pascal1.1
0623 AD1C A0 0B                 ldy   #$0B
0624 AD1E B7 28                 lda   [<fw_addr],y             ; $Cn0B = $01 if Pascal1.1
0625 AD20 3A                    dec   a
0626 AD21 F0 28                 beq   pascal_type              ; if a Pascal1.1 device
0627 AD23              *
0628 AD23              * If got here, then device is a BASIC device.  Dispatch must be through
0629 AD23              * the address previously obtained through the I/O hooks unless this is an
0630 AD23              * initialization dispatch to $Cn00.  Standard BASIC entry points are as
0631 AD23              * follows:
0632 AD23              *               $Cn00   Initializtion entry point
0633 AD23              *               $Cn05   Input routine entry point
0634 AD23              *               $Cn07   Output routine entry point
0635 AD23              *
0636 AD23              * Many BASIC devices do not support the standard input and output entry
0637 AD23              * points.  All BASIC devices modify the I/O hooks located at $0036-0039
0638 AD23              * in absolute zero page.  The result of the initialization call to a
0639 AD23              * BASIC device will store the hooks into a hook table for the input and
0640 AD23              * output dispatches.  The input routine entry point will be obtained
0641 AD23              * from $0038 while the output routine entry point will be obtained from
0642 AD23              * $0036.
0643 AD23              *
0644 AD23              basic_type  
0645 AD23                       longa off
0646 AD23                       longi off
0647 AD23
0648 AD23 9C 13 AC              stz   |c0_flag                 ; flag that its a BASIC device
0649 AD26
0650 AD26 A0 2E                 ldy   #slot_num                ; get slot
0651 AD28 B7 20                 lda   [<drvr_dib_ptr],y
0652 AD2A 29 F7                 and   #$F7                     ;clear external slot bit
0653 AD2C 3A                    dec   a
0654 AD2D 0A                    asl   a
0655 AD2E AA                    tax   
0656 AD2F A5 02                 lda   <drvr_call_num           ; get driver call number
0657 AD31 C9 02                 cmp   #drvr_read               ; is this a read call?
0658 AD33 F0 0E                 beq   get_hook                 ; yes
0659 AD35 E8                    inx   
0660 AD36 C9 03                 cmp   #drvr_write              ; is this a write call?
0661 AD38 F0 09                 beq   get_hook                 ; yes
0662 AD3A C9 01                 cmp   #drvr_open               ; is it an open call
0663 AD3C
0664 AD3C 38                    sec                            ; assume it's not an open
0665 AD3D D0 24                 bne   char_ret_1               ; no other BASIC dispatch possible
0666 AD3F
0667 AD3F A9 00                 lda   #$00                     ; set for BASIC init call on open
0668 AD41 80 03                 bra   set_fw_addr
0669 AD43              get_hook  
0670 AD43 BD 67 AC              lda   |hook_table,x            ; get low byte entry $CnXX
0671 AD46              set_fw_addr  
0672 AD46 85 28                 sta   <fw_addr                 ; set low byte of $CnXX entry point
0673 AD48 4C DE AD              jmp   set_reg                  ; and go to dispatch
0674 AD4B
0675 AD4B              *
0676 AD4B              * If got here, then device is a Pascal1.1 driver.  Dispatch must get the
0677 AD4B              * proper entry point for the firmware driver by reading the firmware driver
0678 AD4B              * rom.  Pascal1.1 entry points are defined as follows:
0679 AD4B              *
0680 AD4B              *               $Cn0D   Initialization routine offset
0681 AD4B              *               $Cn0E   Read routine offset
0682 AD4B              *               $Cn0F   Write routine offset
0683 AD4B              *               $Cn10   Status routine offset
0684 AD4B              *
0685 AD4B              pascal_type  
0686 AD4B                       longa off
0687 AD4B                       longi off
0688 AD4B
0689 AD4B A0 0D                 ldy   #$0D                     ; assume initialization call
0690 AD4D A5 02                 lda   <drvr_call_num
0691 AD4F C9 01                 cmp   #drvr_open               ; is this an open call?
0692 AD51 F0 1D                 beq   pascal_entry             ; yes
0693 AD53 C8                    iny   
0694 AD54 C9 02                 cmp   #drvr_read               ; is this a read call?
0695 AD56 F0 18                 beq   pascal_entry             ; yes
0696 AD58 C8                    iny   
0697 AD59 C9 03                 cmp   #drvr_write              ; is this a write call?
0698 AD5B F0 13                 beq   pascal_entry
0699 AD5D C8                    iny   
0700 AD5E C9 05                 cmp   #drvr_status             ; is this a status call?
0701 AD60 F0 0E                 beq   pascal_entry             ; yes
0702 AD62
0703 AD62              char_ret  
0704 AD62 18                    clc                            ; no error exit
0705 AD63              char_ret_1                              ; or pass carry from previous routine
0706 AD63 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
0707 AD65                       longa on
0708 AD65                       longi on
0709 AD65
0710 AD65 2B                    pld                            ; restore native environment
0711 AD66 AB                    plb   
0712 AD67 AF 2C AC 00           lda   >save_sp
0713 AD6B 1B                    tcs   
0714 AD6C A9 00 00              lda   #no_error                ; A Reg has error code
0715 AD6F 6B                    rtl   
0716 AD70
0717 AD70              pascal_entry  
0718 AD70 B7 28                 lda   [<fw_addr],y             ; get firmware entry point offset
0719 AD72 85 28                 sta   <fw_addr
0720 AD74 80 68                 bra   set_reg                  ; now ready for dispatch
0721 AD76
0722 AD76              *
0723 AD76              * If got here the device is either a class 1 or class 2 driver.  Must
0724 AD76              * determine which class it is since the call structure is not the same
0725 AD76              * for both of these classes of driver.
0726 AD76              *
0727 AD76              not_class0  
0728 AD76                       longa off
0729 AD76                       longi on
0730 AD76
0731 AD76 3A                    dec   a                        ; is it a class 1 driver?
0732 AD77 D0 29                 bne   class2                   ; no, must be class 2
0733 AD79
0734 AD79              *
0735 AD79              * If got here the device is a class 1 driver using the standard
0736 AD79              * SmartPort interface.  Must set up a SmartPort parameter block
0737 AD79              * in bank 0.  Then a command byte and word pointer to the parameter
0738 AD79              * list must be stored over the first 3 nop's just after the bank 0
0739 AD79              * dispatch return address.
0740 AD79              *
0741 AD79              *               ($CnFF) + $Cn00 + $03 = SmartPort entry point
0742 AD79              *
0743 AD79              class1    
0744 AD79                       longa off
0745 AD79                       longi on
0746 AD79
0747 AD79 A0 FF 00              ldy   #$00FF                   ; get ProDOS block entry point
0748 AD7C B1 28                 lda   (<fw_addr),y
0749 AD7E 18                    clc                            ; now add 3 to get SmartPort entry
0750 AD7F 69 03                 adc   #$03
0751 AD81 85 28                 sta   <fw_addr
0752 AD83
0753 AD83              *
0754 AD83              * Now must set up call number, parameter list pointer and the
0755 AD83              * parameter list itself.  Parameter lists take on many formats.
0756 AD83              *
0757 AD83 20 11 AF              jsr   set_sp_command           ; set up smartport command
0758 AD86 B0 0D                 bcs   no_sp_dsptch             ; if dispatch doesnt apply to device
0759 AD88 C2 20                 rep   #$20                     ; 16 bit 'm'
0760 AD8A                       longa on
0761 AD8A A9 1D AC              lda   #parm_list               ; set pointer to parameter list
0762 AD8D 8D 17 AE              sta   |parm_list_ptr
0763 AD90 E2 20                 sep   #$20                     ; 8 bit 'm'
0764 AD92                       longa off
0765 AD92 4C DE AD              jmp   set_reg                  ; ready for dispatch
0766 AD95
0767 AD95              no_sp_dsptch  
0768 AD95 2B                    pld   
0769 AD96 AB                    plb   
0770 AD97 C2 20                 rep   #$20                     ; 16 bit 'm'
0771 AD99                       longa off
0772 AD99 AF 2C AC 00           lda   >save_sp                 ; restore native mode stack
0773 AD9D 1B                    tcs   
0774 AD9E A9 00                 lda   #$0000                   ; report no error
0775 ADA0 18                    clc   
0776 ADA1 6B                    rtl                            ; and return like an extended dispatch
0777 ADA2
0778 ADA2              *
0779 ADA2              * If got here the device is a class 2 driver using the extended
0780 ADA2              * SmartPort interface.  Must set up an extended SmartPort parameter
0781 ADA2              * block in any bank. A command byte and longword pointer to the parameter
0782 ADA2              * list must be stored over the all 5 nop's just after the bank 0
0783 ADA2              * dispatch return address.
0784 ADA2              *
0785 ADA2              *               ($CnFF) + $Cn00 + $03 = SmartPort entry point
0786 ADA2              *
0787 ADA2              class2    
0788 ADA2                       longa off
0789 ADA2                       longi on
0790 ADA2
0791 ADA2 A0 FF 00              ldy   #$00FF                   ; get ProDOS block entry point
0792 ADA5 B1 28                 lda   (<fw_addr),y
0793 ADA7 18                    clc                            ; now add 3 to get SmartPort entry
0794 ADA8 69 03                 adc   #$03
0795 ADAA 85 28                 sta   <fw_addr
0796 ADAC 20 11 AF              jsr   set_sp_command           ; set up smartport command
0797 ADAF B0 E4                 bcs   no_sp_dsptch             ; if dispatch doesnt apply to device
0798 ADB1 A9 40                 lda   #$40                     ; make it an extended command
0799 ADB3 0C 16 AE              tsb   |sp_command
0800 ADB6 C2 20                 rep   #$20                     ; 16 bit 'm'
0801 ADB8                       longa on
0802 ADB8 A9 1D AC              lda   #parm_list               ; set pointer to parameter list
0803 ADBB 8D 17 AE              sta   |parm_list_ptr
0804 ADBE 9C 19 AE              stz   |parm_list_ptr+2
0805 ADC1 E2 20                 sep   #$20                     ; 8 bit 'm'
0806 ADC3                       longa off
0807 ADC3 80 19                 bra   set_reg
0808 ADC5
0809 ADC5                       EJECT 
0810 ADC5              ***************************************************************
0811 ADC5              *
0812 ADC5              * Now ready to dispatch to firmware driver.  Must set up registers for
0813 ADC5              * emulation mode dispatch as follows:
0814 ADC5              *
0815 ADC5              *               X = $Cn
0816 ADC5              *               Y = $n0
0817 ADC5              *               A = character to output
0818 ADC5              *
0819 ADC5              * The address on direct page (fw_addr) must be decremented and
0820 ADC5              * placed on the stack since the mechanism for the dispatch is
0821 ADC5              * an 'RTS' instruction.  Prior to dispatching, the direct register
0822 ADC5              * must be set to absolute zero page.  Switch to emulation mode
0823 ADC5              * occurs here.  This routine must switch the ROM in prior to
0824 ADC5              * dispatching to the firmware.  In addition, the system speed will
0825 ADC5              * be set to SLOW if the dispatch is to a slot rather than a port. 
0826 ADC5              *
0827 ADC5              * ENTRY:        A Reg = Undefined
0828 ADC5              *               X Reg = Undefined
0829 ADC5              *               Y Reg = Undefined
0830 ADC5              *               B Reg = $00
0831 ADC5              *             DIR Reg = GS/OS Direct Page
0832 ADC5              *               P Reg = 8 bit 'm', 8 or 16 bit 'x', native mode
0833 ADC5              *             FW_ADDR = Entry point in firmware
0834 ADC5              *
0835 ADC5              * EXIT:         A Reg = As returned from firmware
0836 ADC5              *               X Reg = Combined X & Y returned from firmware
0837 ADC5              *               Y Reg = Y returned from firmware
0838 ADC5              *               B Reg = $00
0839 ADC5              *             DIR Reg = GS/OS Direct Page
0840 ADC5              *               P Reg = Carry returned from firmware
0841 ADC5              *                       16 bit 'm' & 'x' native mode
0842 ADC5              *
0843 ADC5              ***************************************************************
0844 ADC5              *
0845 ADC5              * The core routine is provided only for the device dispatcher
0846 ADC5              * which must call SmartPort prior to having a device list
0847 ADC5              * constructed.
0848 ADC5              *
0849 ADC5              ***************************************************************
0850 ADC5                       export b0_core
0851 ADC5              b0_core   
0852 ADC5 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
0853 ADC7                       longa on
0854 ADC7                       longi on
0855 ADC7
0856 ADC7              *
0857 ADC7              * This routine sets the stack pointer to page 1 in preperation
0858 ADC7              * for switching to emulation mode.
0859 ADC7              *
0860 ADC7 3B                    tsc                            ; save native sp
0861 ADC8 8F 2C AC 00           sta   >save_sp
0862 ADCC E2 20                 sep   #$20                     ; 8 bit 'm'
0863 ADCE                       longa off
0864 ADCE
0865 ADCE EB                    xba                            ; get stack page in A
0866 ADCF 3A                    dec   a                        ; is stack in page 1?
0867 ADD0 F0 08                 beq   page1                    ; yes
0868 ADD2 A9 01                 lda   #$01                     ; if not, set page 1
0869 ADD4 EB                    xba   
0870 ADD5 AF 00 01 01           lda   >emulstack               ; get emulation mode stack pointer
0871 ADD9 1B                    tcs                            ; to set page 1 stack pointer
0872 ADDA              page1     
0873 ADDA
0874 ADDA 8B                    phb   
0875 ADDB 0B                    phd   
0876 ADDC 4B                    phk                            ; need data bank = $00
0877 ADDD AB                    plb   
0878 ADDE
0879 ADDE                       eject 
0880 ADDE              ***************************************************************
0881 ADDE              *
0882 ADDE              * This is the normal entry for dispatches to firmware via
0883 ADDE              * the bank 0 dispatcher.
0884 ADDE              *
0885 ADDE              * Native and emulation stacks contain the following:
0886 ADDE              *
0887 ADDE              * NATIVE STACK          EMULATION STACK
0888 ADDE              *
0889 ADDE              *      K                 .
0890 ADDE              *      PCH               .
0891 ADDE              *      PCL               .
0892 ADDE              *      .                 Data Bank
0893 ADDE              *      .                 Dir Reg High
0894 ADDE              *      .                 Dir Reg Low
0895 ADDE              *
0896 ADDE              ***************************************************************
0897 ADDE                       export set_reg
0898 ADDE              set_reg   
0899 ADDE                       longa off
0900 ADDE              ;               longi   not determined at this entry point
0901 ADDE              *
0902 ADDE              * Save system environment prior to dispatch.
0903 ADDE              * 
0904 ADDE E2 10                 sep   #$10                     ; 8 bit 'x'
0905 ADE0                       longi off
0906 ADE0 AD 36 C0              lda   |cyareg                  ; save system speed
0907 ADE3 48                    pha   
0908 ADE4 AD 68 C0              lda   |statereg                ; and rom enable
0909 ADE7 48                    pha   
0910 ADE8              *
0911 ADE8              * Must determine if the slot the dispatch will be executed to
0912 ADE8              * is internal or external prior to setting the system speed.
0913 ADE8              * System speed will be forced slow for external slots.
0914 ADE8              *
0915 ADE8 A0 2E                 ldy   #slot_num                ; get slot number
0916 ADEA B7 20                 lda   [<drvr_dib_ptr],y
0917 ADEC 29 08                 and   #%00001000               ; if bit 3=1 then external
0918 ADEE 20 0C AF              jsr   a_times_16
0919 ADF1 1C 36 C0              trb   |cyareg                  ; set system speed
0920 ADF4 A9 08                 lda   #%00001000               ; turn on the rom
0921 ADF6 8D 68 C0              sta   |statereg
0922 ADF9 08                    php                            ; in case card disables IRQ
0923 ADFA              *
0924 ADFA              * Now get ready for dispatch by placing return address as well
0925 ADFA              * as dispatch address on the stack.
0926 ADFA              * 
0927 ADFA C2 20                 rep   #$20                     ; 16 bit 'm'
0928 ADFC                       longa on
0929 ADFC F4 15 AE              pea   fw_return-1              ; return address will be 5 nops
0930 ADFF A5 28                 lda   <fw_addr                 ; decrement address prior to push
0931 AE01 3A                    dec   a
0932 AE02 48                    pha   
0933 AE03              *
0934 AE03              * Ready for dispatch and return so set emulation mode and
0935 AE03              * register states for dispatch.
0936 AE03              *
0937 AE03 38                    sec                            ; set emulation mode
0938 AE04 FB                    xce   
0939 AE05                       longa off
0940 AE05                       longi off
0941 AE05 A6 29                 ldx   <fw_addr+1               ; set up register states
0942 AE07 8A                    txa                            ; have $Cn in X
0943 AE08 20 0C AF              jsr   a_times_16
0944 AE0B A8                    tay   
0945 AE0C AD 2E AC              lda   |a_reg
0946 AE0F F4 00 00              pea   $0000                    ; set absolute zero page
0947 AE12 2B                    pld   
0948 AE13 4B                    phk   
0949 AE14 AB                    plb   
0950 AE15
0951 AE15                       eject 
0952 AE15              *
0953 AE15              * Native and emulation stacks contain the following:
0954 AE15              *
0955 AE15              * NATIVE STACK          EMULATION STACK
0956 AE15              *
0957 AE15              *      K                 .
0958 AE15              *      PCH               .
0959 AE15              *      PCL               .
0960 AE15              *      .                 Data Bank
0961 AE15              *      .                 Dir Reg High
0962 AE15              *      .                 Dir Reg Low
0963 AE15              *                        CYA Register
0964 AE15              *                        State Register
0965 AE15              *                        processor Status (save IRQ enable)
0966 AE15              *                        FW_RET-1 (High)
0967 AE15              *                        FW_RET-1 (Low)
0968 AE15              *                        ENTRY-1 (High)
0969 AE15              *                        ENTRY-1 (Low)
0970 AE15              *
0971 AE15 60                    rts                            ; dispatch to ENTRY
0972 AE16
0973 AE16                       EJECT 
0974 AE16              ***************************************************************
0975 AE16              *
0976 AE16              * On return from fw_addr, the execution address depends on the driver
0977 AE16              * class that the fw_addr dispatch was executed to.
0978 AE16              *
0979 AE16              * Class 0 will resume at fw_return
0980 AE16              * Class 1 will resume at fw_return+3
0981 AE16              * Class 2 will resume at fw_return+5
0982 AE16              *
0983 AE16              ***************************************************************
0984 AE16                       export fw_return
0985 AE16              fw_return  
0986 AE16                       export sp_command
0987 AE16              sp_command  
0988 AE16 05                    DC B:$ea                       ; NOP or SmartPort command
0989 AE17                       export parm_list_ptr
0990 AE17              parm_list_ptr  
0991 AE17 1D                    DC B:$ea                       ; NOP or Parameter list pointer
0992 AE18 AC                    DC B:$ea                       ; NOP or Parameter list pointer
0993 AE19 00                    DC B:$ea                       ; NOP or Parameter list pointer
0994 AE1A 00                    DC B:$ea                       ; NOP or Parameter list pointer
0995 AE1B
0996 AE1B                       eject 
0997 AE1B              ***************************************************************
0998 AE1B              *
0999 AE1B              * Must restore driver environment while preserving the status
1000 AE1B              * that was returned from the firmware driver.  The environment
1001 AE1B              * includes direct page, data bank & stack pointer.  Additionally,
1002 AE1B              * the proper error status for the device must be returned.
1003 AE1B              * Error status varies among devices as follows:
1004 AE1B              *
1005 AE1B              * BASIC:        No error status is supported.
1006 AE1B              *               A Reg = Character
1007 AE1B              *               X Reg = Undefined
1008 AE1B              *               Y Reg = Undefined
1009 AE1B              *
1010 AE1B              * PASCAL:       A Reg = Character
1011 AE1B              *               X Reg = Error Code
1012 AE1B              *               Y Reg = $n0
1013 AE1B              *
1014 AE1B              * ProDOS:       A Reg = Error code if carry set
1015 AE1B              *               X Reg = Low byte block count on STATUS
1016 AE1B              *               Y Reg = High byte block count on STATUS
1017 AE1B              *
1018 AE1B              * SmartPort:    A Reg = Error code if carry set
1019 AE1B              *               X Reg = Low byte transfer count on READ/RDBLK
1020 AE1B              *               Y Reg = High byte transfer count on READ/RDBLK
1021 AE1B              *
1022 AE1B              ***************************************************************
1023 AE1B                       export unfutz
1024 AE1B              unfutz              
1025 AE1B                       longa off
1026 AE1B                       longi off
1027 AE1B              *
1028 AE1B              * Save away the error code while switching modes.
1029 AE1B              * The V flag will be set if a soft error occured.  Soft
1030 AE1B              * errors will be filtered before returning to the generated
1031 AE1B              * driver core routines.
1032 AE1B              *
1033 AE1B 8E 16 AE              stx   |sp_command              ; in case returning from pascal
1034 AE1E 8D 2E AC              sta   |a_reg
1035 AE21 08                    php   
1036 AE22 68                    pla   
1037 AE23 8D 29 AC              sta   |b0_temp
1038 AE26              *
1039 AE26              * Restore system environment on return from dispatch.
1040 AE26              * 
1041 AE26 28                    plp                            ; restore IRQ enable
1042 AE27 68                    pla   
1043 AE28 8D 68 C0              sta   |statereg                ; restore system state reg (rom enbl)
1044 AE2B 68                    pla   
1045 AE2C 8D 36 C0              sta   |cyareg                  ; save system speed
1046 AE2F 2B                    pld                            ; restore native mode direct page
1047 AE30 AB                    plb                            ; restore native mode data bank
1048 AE31              *
1049 AE31              * Switch back to native mode.
1050 AE31              *
1051 AE31 FB                    xce                            ; preserve carry while switching modes
1052 AE32 18                    clc   
1053 AE33 FB                    xce                            ; native mode 8 bit 'm' & 'x'
1054 AE34              *
1055 AE34              * Both 8 bit emulation mode index registers will now be combined
1056 AE34              * into a single 16 bit native mode index register.  The high byte
1057 AE34              * of the 16 bit X register will contain the value of the 8 bit
1058 AE34              * emulation mode Y register while the low byte of the 16 bit X
1059 AE34              * register will contain the value of the 8 bit emulation mode
1060 AE34              * X register.
1061 AE34              *
1062 AE34 98                    tya                            ; combine 8 bit index to a 16 bit reg
1063 AE35 EB                    xba   
1064 AE36 8A                    txa   
1065 AE37 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
1066 AE39                       longa on
1067 AE39                       longi on
1068 AE39 AA                    tax   
1069 AE3A
1070 AE3A                       eject 
1071 AE3A              *
1072 AE3A              * Now restore native mode stack before returning to generated
1073 AE3A              * driver core routines.
1074 AE3A              *  _______________
1075 AE3A              * |       |       |
1076 AE3A              * | HIGH  |  LOW  |     16 bit X Register
1077 AE3A              * |_______|_______|
1078 AE3A              *     |       |________ 8 bit X returned by device
1079 AE3A              *     |________________ 8 bit Y returned by device
1080 AE3A              *
1081 AE3A AF 2C AC 00           lda   >save_sp                 ; restore stack pointer
1082 AE3E 1B                    tcs   
1083 AE3F              *
1084 AE3F              * If this was a return from a SmartPort call then error codes
1085 AE3F              * may need post-processed.  The dib may not contain the driver
1086 AE3F              * class so the five 'NOP' instructions stored for class 0 devices
1087 AE3F              * inline with the dispatch is examined to determine the driver class.
1088 AE3F              *
1089 AE3F AF 17 AE 00           lda   >parm_list_ptr           ; are we counting devices?
1090 AE43 C9 EA EA              cmp   #$EAEA
1091 AE46 D0 79                 bne   not_c0_ret               ; maybe
1092 AE48              *
1093 AE48              * If this was an OPEN call to a BASIC device, then need to
1094 AE48              * save the I/O Hook in table for all other dispatches.
1095 AE48              *
1096 AE48 A0 40 00              ldy   #drvr_class              ; need driver class....
1097 AE4B B7 20                 lda   [<drvr_dib_ptr],y
1098 AE4D F0 5C                 beq   pro_ret                  ; if it's a ProDOS device
1099 AE4F C9 80 00              cmp   #$0080                   ; is it a character device?
1100 AE52 D0 6D                 bne   not_c0_ret               ; no, don't init hook table
1101 AE54
1102 AE54              *
1103 AE54              * new code <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
1104 AE54              * Changed BIT |c0_flag to the following. Note c0_flag is a byte!
1105 AE54              * Bit 7 of C0 flag is set if a Pascal1.1 device or cleared if
1106 AE54              * a BASIC device.
1107 AE54              *
1108 AE54 AF 12 AC 00           lda   >c0_flag-1               ; BASIC or Pascal1.1?
1109 AE58 30 30                 bmi   p_ret                    ; minus if a Pascal1.1 device
1110 AE5A              *
1111 AE5A              * It's a BASIC device.  If this was an OPEN call then
1112 AE5A              * need to initialize the hook table for this device.
1113 AE5A              * If not an OPEN then just return with no error!
1114 AE5A              *
1115 AE5A              b_ret     
1116 AE5A A5 02                 lda   <drvr_call_num           ; is it an open call?
1117 AE5C C9 01 00              cmp   #drvr_open
1118 AE5F D0 20                 bne   not_b_open               ; no, don't init hook table
1119 AE61 A0 2E 00              ldy   #slot_num
1120 AE64 B7 20                 lda   [<drvr_dib_ptr],y
1121 AE66 29 07 00              and   #$0007                   ;clear external slot bit
1122 AE69 3A                    dec   a                        ;minus one for zero based table.
1123 AE6A 0A                    asl   a
1124 AE6B AA                    tax                            ; now have proper index to table
1125 AE6C
1126 AE6C E2 20                 sep   #$20                     ; 8 bit 'm'
1127 AE6E                       longa off
1128 AE6E
1129 AE6E AF 38 00 00           lda   >in_hook                 ; send input hook to table
1130 AE72 9F 67 AC 00           sta   >hook_table,x
1131 AE76 E8                    inx   
1132 AE77 AF 36 00 00           lda   >out_hook                ; send output hook to table
1133 AE7B 9F 67 AC 00           sta   >hook_table,x
1134 AE7F
1135 AE7F C2 20                 rep   #$20                     ; 16 bit 'm'
1136 AE81                       longa on
1137 AE81              not_b_open  
1138 AE81 AF 2E AC 00           lda   >a_reg                   ; exit with value
1139 AE85 29 FF 00              and   #$00FF
1140 AE88 18                    clc   
1141 AE89 6B                    rtl   
1142 AE8A              *
1143 AE8A              * Returned from a Pascal1.1 device.  If 8 bit quantity returned
1144 AE8A              * in X register is zero then return value with no error.  If 8
1145 AE8A              * bit quantity returned in X register was nonzero then return
1146 AE8A              * X as error.
1147 AE8A              *
1148 AE8A              p_ret     
1149 AE8A A5 02                 lda   <drvr_call_num           ; is it a status call?
1150 AE8C C9 05 00              cmp   #$0005
1151 AE8F D0 04                 bne   not_p_status
1152 AE91
1153 AE91 20 B4 AE              jsr   get_fw_status            ; carry as returned from device
1154 AE94 6B                    rtl   
1155 AE95              not_p_status  
1156 AE95 38                    sec                            ; restore error flag (X register) from device
1157 AE96 AF 16 AE 00           lda   >sp_command
1158 AE9A 29 FF 00              and   #$00FF
1159 AE9D F0 E2                 beq   not_b_open               ; if no error, return data
1160 AE9F E2 20                 sep   #$20                     ; else shift into 8-bit mode
1161 AEA1                       longa off
1162 AEA1 09 10                 ora   #%00010000               ; shift firmware error code into $30-$3F
1163 AEA3 EB                    xba                            ; put error code into high byte
1164 AEA4 AF 2E AC 00           lda   >a_reg                   ; get the returned accumulator value into low byte
1165 AEA8 C2 20                 rep   #$20                     ; back to 16-bit mode
1166 AEAA                       longa on
1167 AEAA 6B                    rtl                            ; return to generated driver
1168 AEAB              *
1169 AEAB              * Return was from a ProDOS block device.  If value returned
1170 AEAB              * in accumulator from device was nonzero then return with that
1171 AEAB              * value as the error code.
1172 AEAB              *
1173 AEAB              pro_ret   
1174 AEAB 20 B4 AE              jsr   get_fw_status            ; get carry flag and accumulator from firmware
1175 AEAE B0 03                 bcs   pro_error                ; if device errored
1176 AEB0 A9 00 00              lda   #no_error                ; else make sure error is cleared
1177 AEB3              pro_error  
1178 AEB3 6B                    rtl   
1179 AEB4
1180 AEB4              get_fw_status  
1181 AEB4 AF 29 AC 00           lda   >b0_temp                 ; restore error flag from device
1182 AEB8 6A                    ror   a
1183 AEB9 AF 2E AC 00           lda   >a_reg                   ; get returned error code
1184 AEBD 29 FF 00              and   #$00FF
1185 AEC0 60                    rts   
1186 AEC1              *
1187 AEC1              * Returned from a SmartPort device.  If any soft error
1188 AEC1              * occured, this error is mapped to no error prior to
1189 AEC1              * returning to the device driver.
1190 AEC1              *
1191 AEC1              not_c0_ret  
1192 AEC1 AF 2E AC 00           lda   >a_reg                   ; retrieve the error code
1193 AEC5 29 40 00              and   #$0040                   ; is it a soft error?
1194 AEC8 D0 2F                 bne   soft_error               ; yes, not really an error
1195 AECA AF 2E AC 00           lda   >a_reg                   ; does error code need translated?
1196 AECE 29 FF 00              and   #$00FF
1197 AED1 C9 01 00              cmp   #$0001                   ; is it a BADCMD?
1198 AED4 D0 05                 bne   not_bad_cmd              ; no
1199 AED6              set_bad_parm  
1200 AED6 A9 22 00              lda   #drvr_bad_parm           ; else translate error code
1201 AED9 80 21                 bra   new_error
1202 AEDB              not_bad_cmd  
1203 AEDB C9 04 00              cmp   #$0004                   ; is it a BADPCNT?
1204 AEDE F0 F6                 beq   set_bad_parm             ; yes
1205 AEE0 C9 11 00              cmp   #$0011                   ; is it a BADUNIT?
1206 AEE3 F0 0A                 beq   set_no_dev               ; yes
1207 AEE5 C9 06 00              cmp   #$0006                   ; is it a BUSSERR?
1208 AEE8 D0 0A                 bne   not_busserr              ; no
1209 AEEA A9 27 00              lda   #drvr_io_error           ; else translate error code
1210 AEED 80 0D                 bra   new_error
1211 AEEF              set_no_dev  
1212 AEEF A9 28 00              lda   #drvr_no_dev
1213 AEF2 80 08                 bra   new_error
1214 AEF4              not_busserr  
1215 AEF4 C9 1F 00              cmp   #$001F                   ; is it a NOINT?
1216 AEF7 D0 03                 bne   new_error                ; no
1217 AEF9              soft_error  
1218 AEF9 A9 00 00              lda   #no_error                ; NOINT is not an error!!!
1219 AEFC              new_error  
1220 AEFC 8F 2E AC 00           sta   >a_reg                   ; save new error code
1221 AF00 38                    sec                            ; assume an error occured
1222 AF01
1223 AF01 AF 2E AC 00           lda   >a_reg                   ; get returned error code
1224 AF05 D0 04                 bne   exit_time                ; assumed correct
1225 AF07 18                    clc   
1226 AF08 A9 00 00              lda   #no_error                ; else make sure error is cleared
1227 AF0B              exit_time  
1228 AF0B 6B                    rtl   
1229 AF0C
1230 AF0C                       export a_times_16
1231 AF0C              a_times_16  
1232 AF0C 0A                    asl   a
1233 AF0D 0A                    asl   a
1234 AF0E 0A                    asl   a
1235 AF0F 0A                    asl   a
1236 AF10 60                    rts   
1237 AF11
1238 AF11
1239 AF11                       endp 
1240 AF11                       EJECT 
1241 AF11              ****************************************************************
1242 AF11              *
1243 AF11              * This routine translates the GS/OS driver call number into
1244 AF11              * a SmartPort call.  If no translation is possible, the
1245 AF11              * Carry flag will be set on return.  This routine will examine
1246 AF11              * the DIB if the call is a read or write request to determine
1247 AF11              * if the device is a character device.  Character devices will
1248 AF11              * receive a read or write command while block devices will
1249 AF11              * receive readblock or writeblock commands.  A format command
1250 AF11              * will only be issued to character devices.  Some other calls
1251 AF11              * will have to be processed at the level just above the bank 0
1252 AF11              * dispatcher (such as : Set_Newline, Get_Newline).
1253 AF11              *
1254 AF11              * ENTRY:        A Reg = Undefined
1255 AF11              *               X Reg = Undefined
1256 AF11              *               Y Reg = Undefined
1257 AF11              *             DIR Reg = GS/OS Direct Page
1258 AF11              *               B Reg = Bank Zero
1259 AF11              *               P Reg = 0=e=x, 1=m
1260 AF11              *
1261 AF11              * EXIT:         A Reg = Undefined
1262 AF11              *               X Reg = Undefined
1263 AF11              *               Y Reg = Undefined
1264 AF11              *             DIR Reg = GS/OS Direct Page
1265 AF11              *               B Reg = Bank Zero
1266 AF11              *               P Reg = 0=e=x, 1=m,
1267 AF11              *                       C=1 if dispatch doesnt apply.
1268 AF11              *                       C=0 if dispatch does apply & parameter
1269 AF11              *                       block is set up.
1270 AF11              *
1271 AF11              ****************************************************************
1272 AF11                       export set_sp_command
1273 AF11              set_sp_command proc 
1274 AF11                       longa off
1275 AF11                       longi on
1276 AF11
1277 AF11 C2 21                 rep   #$21                     ; 16 bit 'm' & carry clear
1278 AF13                       longa on
1279 AF13 F4 1E AF              pea   set_sp_ret-1             ; on return from setup routine
1280 AF16 A5 02                 lda   <drvr_call_num           ; get GS/OS command
1281 AF18 0A                    asl   a
1282 AF19 AA                    tax   
1283 AF1A BD 9F B0              lda   |sp_translate,x          ; routine to do setup
1284 AF1D 48                    pha   
1285 AF1E 60                    rts                            ; dispatch to setup
1286 AF1F              set_sp_ret                              ; ; back to central dispatcher
1287 AF1F E2 20                 sep   #$20                     ; 8 bit 'm'
1288 AF21                       longa off
1289 AF21 60                    rts   
1290 AF22
1291 AF22              *
1292 AF22              * Both the startup and shutdown calls are always translated into
1293 AF22              * a a standard control call with a control code of $00 to reset the device.
1294 AF22              *
1295 AF22                       export sp_start_up
1296 AF22              sp_start_up  
1297 AF22                       longa on
1298 AF22                       longi on
1299 AF22
1300 AF22                       export sp_shut_dn
1301 AF22              sp_shut_dn  
1302 AF22                       longa on
1303 AF22                       longi on
1304 AF22 A9 04 00              lda   #$0004                   ; SmartPort control call
1305 AF25 8D 16 AE              sta   |sp_command
1306 AF28 A0 2F 00              ldy   #unit_num-1              ; want dib unit number in high byte
1307 AF2B B7 20                 lda   [<drvr_dib_ptr],y
1308 AF2D 29 00 FF              and   #$FF00                   ; low byte will be pcount
1309 AF30 09 03 00              ora   #$0003
1310 AF33 8D 1D AC              sta   |parm_list
1311 AF36 9C 1F AC              stz   |parm_list+2             ; no control list
1312 AF39 9C 20 AC              stz   |parm_list+3             ; control code = reset device ($00)
1313 AF3C 60                    rts   
1314 AF3D
1315 AF3D              *
1316 AF3D              * The open call only applies to character devices.  The carry will
1317 AF3D              * be returned set if the dispatch is referencing a block device.
1318 AF3D              * Only standard OPEN parameter blocks will be generated for character
1319 AF3D              * devices.
1320 AF3D                       export sp_open
1321 AF3D              sp_open   
1322 AF3D                       longa on
1323 AF3D                       longi on
1324 AF3D
1325 AF3D 20 56 AF              jsr   b0_get_dev_char          ; get device characteristics
1326 AF40 F0 02                 beq   sp_open_char             ; if character device
1327 AF42 38                    sec                            ; else no dispatch
1328 AF43 60                    rts   
1329 AF44              sp_open_char  
1330 AF44 A9 06 00              lda   #$0006                   ; SmartPort OPEN call
1331 AF47              sp_open_close  
1332 AF47 8D 16 AE              sta   |sp_command
1333 AF4A A0 2F 00              ldy   #unit_num-1              ; want dib unit number in high byte
1334 AF4D B7 20                 lda   [<drvr_dib_ptr],y
1335 AF4F 29 00 FF              and   #$FF00                   ; low byte will be pcount
1336 AF52 09 01 00              ora   #$0001
1337 AF55 60                    rts   
1338 AF56
1339 AF56                       export b0_get_dev_char
1340 AF56              b0_get_dev_char  
1341 AF56 A0 08 00              ldy   #dev_char                ; get at device characteristics
1342 AF59 B7 20                 lda   [<drvr_dib_ptr],y
1343 AF5B 29 80 00              and   #$0080                   ; block or character device?
1344 AF5E 60                    rts   
1345 AF5F
1346 AF5F              *
1347 AF5F              * This call applies to both character and block devices.  If the device
1348 AF5F              * is a character device, a standard or extended read parameter block will
1349 AF5F              * be generated.  If the device is a block device and the block size is not
1350 AF5F              * 512 bytes, then a standard or extended read parameter block will be
1351 AF5F              * generated.  If the device is a block device and the block size is 512 bytes
1352 AF5F              * then a standard or extended readblock parameter block will be generated.
1353 AF5F              * The generation of standard versus extended parameters blocks is based on
1354 AF5F              * the driver class obtained from the GDIB.
1355 AF5F              *
1356 AF5F                       export sp_read
1357 AF5F              sp_read   
1358 AF5F                       longa on
1359 AF5F                       longi on
1360 AF5F A9 01 00              lda   #$0001                   ; standard SP readblock call
1361 AF62              *
1362 AF62              * This entry point used to set initial SmartPort command up.
1363 AF62              * If the device is a character device, the command will be
1364 AF62              * converted from a block device command to a character device
1365 AF62              * command.
1366 AF62              *
1367 AF62              sp_rd_wr  
1368 AF62 8D 16 AE              sta   |sp_command              ; set initial sp command
1369 AF65 20 56 AF              jsr   b0_get_dev_char          ; is this a character device?
1370 AF68 D0 0C                 bne   not_sp_char              ; no, it's a block device
1371 AF6A              *
1372 AF6A              * If the block is a nonstandard size or the device is a character
1373 AF6A              * device, the command is converted here to a character device command.
1374 AF6A              *
1375 AF6A              not_std_block  
1376 AF6A AD 16 AE              lda   |sp_command              ; convert command to extended
1377 AF6D 18                    clc   
1378 AF6E 69 07 00              adc   #$0007
1379 AF71 8D 16 AE              sta   |sp_command
1380 AF74 80 07                 bra   set_rd_parms             ; now setup the read parameter block
1381 AF76              *
1382 AF76              * If the block size is not a standard 512 byte block then must
1383 AF76              * use the SmartPort character device protocol to access a non
1384 AF76              * standard block size.  This routine sets the proper command
1385 AF76              * based on the requested block size.
1386 AF76              *
1387 AF76              not_sp_char  
1388 AF76 A5 14                 lda   <drvr_blk_size           ; is request standard block size (512)?
1389 AF78 C9 00 02              cmp   #$0200
1390 AF7B D0 ED                 bne   not_std_block            ; no
1391 AF7D              *
1392 AF7D              * Now must determine if device supports extended commands.  If so, the
1393 AF7D              * command will be converted to the extended format.
1394 AF7D              *
1395 AF7D              set_rd_parms  
1396 AF7D A0 40 00              ldy   #drvr_class              ; does it support extended calls?
1397 AF80 B7 20                 lda   [<drvr_dib_ptr],y
1398 AF82 C9 02 00              cmp   #$0002
1399 AF85 D0 59                 bne   not_extended             ; no
1400 AF87              *
1401 AF87              * Now need to know if it's a character or block device call in order
1402 AF87              * to set the proper parameter block up for the call.
1403 AF87              *
1404 AF87 AD 16 AE              lda   sp_command               ; else change to extended call
1405 AF8A 29 08 00              and   #$0008                   ; block or character call?
1406 AF8D D0 28                 bne   ext_char                 ; it's an extended character call
1407 AF8F              *
1408 AF8F              * It's a block device so let's set up the extended block device
1409 AF8F              * parameter block.
1410 AF8F              *
1411 AF8F A0 2F 00              ldy   #unit_num-1              ; want dib unit number in high byte
1412 AF92 B7 20                 lda   [<drvr_dib_ptr],y
1413 AF94 29 00 FF              and   #$FF00                   ; low byte will be pcount
1414 AF97 09 03 00              ora   #$0003
1415 AF9A 8D 1D AC              sta   |parm_list
1416 AF9D A5 04                 lda   <drvr_buf_ptr            ; set buffer pointer
1417 AF9F 8D 1F AC              sta   |parm_list+2
1418 AFA2 A5 06                 lda   <drvr_buf_ptr+2
1419 AFA4 8D 21 AC              sta   |parm_list+4
1420 AFA7 A5 10                 lda   <drvr_blk_num            ; set block address
1421 AFA9 8D 23 AC              sta   |parm_list+6
1422 AFAC 8F 00 30 FF           sta   >$FF3000                 ; *** WARNING *** this overflows the code space
1423 AFB0 A5 12                 lda   <drvr_blk_num+2
1424 AFB2 8D 25 AC              sta   |parm_list+8
1425 AFB5 18                    clc   
1426 AFB6 60                    rts   
1427 AFB7              *
1428 AFB7              * It's a character device so let's set up the extended character
1429 AFB7              * device parameter block.
1430 AFB7              *
1431 AFB7              ext_char  
1432 AFB7 A0 2F 00              ldy   #unit_num-1              ; want dib unit number in high byte
1433 AFBA B7 20                 lda   [<drvr_dib_ptr],y
1434 AFBC 29 00 FF              and   #$FF00                   ; low byte will be pcount
1435 AFBF 09 04 00              ora   #$0004
1436 AFC2 8D 1D AC              sta   |parm_list
1437 AFC5 A5 04                 lda   <drvr_buf_ptr            ; set buffer pointer
1438 AFC7 8D 1F AC              sta   |parm_list+2
1439 AFCA A5 06                 lda   <drvr_buf_ptr+2
1440 AFCC 8D 21 AC              sta   |parm_list+4
1441 AFCF A5 14                 lda   <drvr_blk_size           ; set block size
1442 AFD1 8D 23 AC              sta   |parm_list+6
1443 AFD4 A5 10                 lda   <drvr_blk_num            ; set block address
1444 AFD6 8D 25 AC              sta   |parm_list+8
1445 AFD9 A5 12                 lda   <drvr_blk_num+2
1446 AFDB 8D 27 AC              sta   |parm_list+10
1447 AFDE 18                    clc   
1448 AFDF 60                    rts   
1449 AFE0              *
1450 AFE0              * It's an standard command so let's leave the command alone and just
1451 AFE0              * set up the pointer to the parameter list.
1452 AFE0              *
1453 AFE0              not_extended  
1454 AFE0              *
1455 AFE0              * Now need to know if it's a character or block device call in order
1456 AFE0              * to set the proper parameter block up for the call.
1457 AFE0              *
1458 AFE0 AD 16 AE              lda   |sp_command              ; is it a character device call?
1459 AFE3 29 08 00              and   #$0008
1460 AFE6 D0 23                 bne   std_char                 ; yes, go set up character parms
1461 AFE8              *
1462 AFE8              * It's a block device so let's set up the extended block device
1463 AFE8              * parameter block.
1464 AFE8              *
1465 AFE8 A0 2F 00              ldy   #unit_num-1              ; want dib unit number in high byte
1466 AFEB B7 20                 lda   [<drvr_dib_ptr],y
1467 AFED 29 00 FF              and   #$FF00                   ; low byte will be pcount
1468 AFF0 09 03 00              ora   #$0003
1469 AFF3 8D 1D AC              sta   |parm_list
1470 AFF6 A5 04                 lda   <drvr_buf_ptr            ; set buffer pointer
1471 AFF8 8D 1F AC              sta   |parm_list+2
1472 AFFB A5 10                 lda   <drvr_blk_num            ; set block address
1473 AFFD 8D 21 AC              sta   |parm_list+4
1474 B000 8F 00 30 FF           sta   >$FF3000                 ; *** WARNING *** this overflows the code space
1475 B004 A5 11                 lda   <drvr_blk_num+1
1476 B006 8D 22 AC              sta   |parm_list+5
1477 B009 18                    clc   
1478 B00A 60                    rts   
1479 B00B              *
1480 B00B              * It's a character device so let's set up the extended character
1481 B00B              * device parameter block.
1482 B00B              *
1483 B00B              std_char  
1484 B00B A0 2F 00              ldy   #unit_num-1              ; want dib unit number in high byte
1485 B00E B7 20                 lda   [<drvr_dib_ptr],y
1486 B010 29 00 FF              and   #$FF00                   ; low byte will be pcount
1487 B013 09 04 00              ora   #$0004
1488 B016 8D 1D AC              sta   |parm_list
1489 B019 A5 04                 lda   <drvr_buf_ptr            ; set buffer pointer
1490 B01B 8D 1F AC              sta   |parm_list+2
1491 B01E A0 48 00              ldy   #block_size              ; set block size
1492 B021 B7 20                 lda   [<drvr_dib_ptr],y
1493 B023 8D 21 AC              sta   |parm_list+4
1494 B026 A5 10                 lda   <drvr_blk_num            ; set block address
1495 B028 8D 23 AC              sta   |parm_list+6
1496 B02B A5 11                 lda   <drvr_blk_num+1
1497 B02D 8D 24 AC              sta   |parm_list+7
1498 B030 18                    clc   
1499 B031 60                    rts   
1500 B032
1501 B032              *
1502 B032              * This call applies to both character and block devices.  If the device
1503 B032              * is a character device, a standard or extended write parameter block will
1504 B032              * be generated.  If the device is a block device and the block size is not
1505 B032              * 512 bytes, then a standard or extended write parameter block will be
1506 B032              * generated.  If the device is a block device and the block size is 512 bytes
1507 B032              * then a standard or extended writeblock parameter block will be generated.
1508 B032              * The generation of standard versus extended parameters blocks is based on
1509 B032              * the driver class obtained from the GDIB.
1510 B032              *
1511 B032                       export sp_write
1512 B032              sp_write  
1513 B032                       longa on
1514 B032                       longi on
1515 B032
1516 B032 A9 02 00              lda   #$0002                   ; SmartPort writeblock command
1517 B035 4C 62 AF              jmp   sp_rd_wr
1518 B038
1519 B038              *
1520 B038              * The close call only applies to character devices.  The carry will
1521 B038              * be returned set if the dispatch is referencing a block device.
1522 B038              * Only standard CLOSE parameter blocks will be generated for character
1523 B038              * devices.
1524 B038                       export sp_close
1525 B038              sp_close  
1526 B038                       longa on
1527 B038                       longi on
1528 B038
1529 B038 20 56 AF              jsr   b0_get_dev_char          ; is this a block or character device?
1530 B03B F0 02                 beq   sp_close_char            ; if character device
1531 B03D 38                    sec                            ; else no dispatch
1532 B03E 60                    rts   
1533 B03F              sp_close_char  
1534 B03F A9 07 00              lda   #$0007                   ; SmartPort CLOSE call
1535 B042 4C 47 AF              jmp   sp_open_close
1536 B045
1537 B045              *
1538 B045              * This routine sets up the device for a Status dispatch.  If the
1539 B045              * device supports extended format, an extended status call will
1540 B045              * be issued.  For standard status calls, the system buffer will
1541 B045              * be used to return status information.
1542 B045              *
1543 B045                       export sp_status
1544 B045              sp_status  
1545 B045                       longa on
1546 B045                       longi on
1547 B045 A0 B1 B0              ldy   #sp_stat_trans           ; assume standard status
1548 B048 A5 2B                 lda   <d_class
1549 B04A 29 0F 00              and   #$000F
1550 B04D 3A                    dec   a                        ; is it a class 1 device?
1551 B04E F0 13                 beq   setup_plist              ; yes, assumed correct!
1552 B050 A0 B3 B0              ldy   #esp_stat_trans          ; else point at extended list
1553 B053 80 0E                 bra   setup_plist              ; and setup command/plist
1554 B055
1555 B055                       export sp_control
1556 B055              sp_control  
1557 B055                       longa on
1558 B055                       longi on
1559 B055 A0 B5 B0              ldy   #sp_ctrl_trans           ; assume standard control
1560 B058 A5 2B                 lda   <d_class
1561 B05A 29 0F 00              and   #$000F
1562 B05D 3A                    dec   a                        ; is it a class 1 device?
1563 B05E F0 03                 beq   setup_plist              ; yes, assumed correct!
1564 B060 A0 BD B0              ldy   #esp_ctrl_trans          ; else point at extended list
1565 B063
1566 B063                       EJECT 
1567 B063              ****************************************************************
1568 B063              *
1569 B063              * This code segment sets up the SmartPort command and the
1570 B063              * parameter list associated with that command.  This routine
1571 B063              * is only used by GS/OS status or control calls
1572 B063              *
1573 B063              * ENTRY:        A Reg = Undefined
1574 B063              *               X Reg = Undefined
1575 B063              *               Y Reg = Pointer to translate table
1576 B063              *             Dir Reg = GS/OS direct page
1577 B063              *               B Reg = Undefined
1578 B063              *               S Reg = Native mode stack
1579 B063              *               P Reg = 0=m=x=e
1580 B063              *
1581 B063              * EXIT:         A Reg = Undefined
1582 B063              *               X Reg = Undefined
1583 B063              *               Y Reg = Undefined
1584 B063              *             Dir Reg = GS/OS direct page
1585 B063              *               B Reg = Unchanged
1586 B063              *               S Reg = Native mode stack
1587 B063              *               P Reg = 0=m=x=e (c=1 if error, else 0)
1588 B063              *
1589 B063              ****************************************************************
1590 B063              setup_plist  
1591 B063 8C 6B B0              sty   get_ptr+1                ; self modify - lda |$0000,x
1592 B066 A5 16                 lda   <drvr_stat_code          ; point at parameter list
1593 B068 0A                    asl   a
1594 B069 AA                    tax   
1595 B06A BD B3 B0     get_ptr  lda   |$0000,x                 ; get parameter list address
1596 B06D AA                    tax   
1597 B06E A0 00 00              ldy   #$0000
1598 B071 BD 00 00     set_command lda   |$0000,x
1599 B074 8D 16 AE              sta   |sp_command              ; set up command
1600 B077 E8                    inx   
1601 B078 BD 00 00     plist_loop lda   |$0000,x               ; build the parameter list
1602 B07B 99 1D AC              sta   |parm_list,y
1603 B07E C8                    iny   
1604 B07F E8                    inx   
1605 B080 C0 07 00              cpy   #$0007
1606 B083 D0 F3                 bne   plist_loop
1607 B085 A0 30 00              ldy   #unit_num                ; patch unit number from the DIB
1608 B088 B7 20                 lda   [<drvr_dib_ptr],y
1609 B08A EB                    xba   
1610 B08B 0D 1D AC              ora   |parm_list
1611 B08E 8D 1D AC              sta   |parm_list
1612 B091 A5 16                 lda   <drvr_stat_code          ; is this an eject?
1613 B093 C9 02 00              cmp   #$0002
1614 B096 D0 03                 bne   sys_buf_done
1615 B098 9C 00 AA              stz   |sys_buffer              ; control list needs $0000 count
1616 B09B              sys_buf_done  
1617 B09B 18                    clc   
1618 B09C 60                    rts   
1619 B09D
1620 B09D              *
1621 B09D              * There is no equivalent function for smartport.  No dispatch will be
1622 B09D              * issued to a device.  This routine will return with carry set to indicate
1623 B09D              * no dispatch should occur.
1624 B09D              *
1625 B09D                       export sp_flush
1626 B09D              sp_flush  
1627 B09D                       longa on
1628 B09D                       longi on
1629 B09D 38                    sec   
1630 B09E 60                    rts   
1631 B09F
1632 B09F                       endp 
1633 B09F
1634 B09F              *
1635 B09F              * The following tables are used to translate GS/OS driver
1636 B09F              * call numbers into either standard or extended SmartPort
1637 B09F              * driver call numbers.
1638 B09F              *
1639 B09F                       export sp_translate
1640 B09F              sp_translate proc 
1641 B09F 21 AF                 DC W:sp_start_up-1             ; startup
1642 B0A1 3C AF                 DC W:sp_open-1                 ; open
1643 B0A3 5E AF                 DC W:sp_read-1                 ; read
1644 B0A5 31 B0                 DC W:sp_write-1                ; write
1645 B0A7 37 B0                 DC W:sp_close-1                ; close
1646 B0A9 44 B0                 DC W:sp_status-1               ; status
1647 B0AB 54 B0                 DC W:sp_control-1              ; control
1648 B0AD 9C B0                 DC W:sp_flush-1                ; flush
1649 B0AF 21 AF                 DC W:sp_shut_dn-1              ; shut down
1650 B0B1
1651 B0B1              *
1652 B0B1              * The following table is used to translate GS/OS status codes to a
1653 B0B1              * SmartPort command # and status code.  The table contains a list of
1654 B0B1              * pointers to default parameter lists for the SmartPort call.
1655 B0B1              *
1656 B0B1                       export sp_stat_trans
1657 B0B1              sp_stat_trans  
1658 B0B1 C5 B0                 DC W:std_dev_stat              ; return device status
1659 B0B3                       export esp_stat_trans
1660 B0B3              esp_stat_trans  
1661 B0B3 CB B0                 DC W:ext_dev_stat              ; return device status
1662 B0B5
1663 B0B5              *
1664 B0B5              * The following table is used to translate GS/OS status codes to a
1665 B0B5              * SmartPort command # and control code.  The table contains a list of
1666 B0B5              * pointers to default parameter lists for the SmartPort call.
1667 B0B5              *
1668 B0B5                       export sp_ctrl_trans
1669 B0B5              sp_ctrl_trans  
1670 B0B5 D3 B0                 DC W:std_reset                 ; reset device
1671 B0B7 E1 B0                 DC W:std_format                ; format device
1672 B0B9 E7 B0                 DC W:std_eject                 ; eject media
1673 B0BB F5 B0                 DC W:std_set_dcb               ; set control parameters
1674 B0BD                       export esp_ctrl_trans
1675 B0BD              esp_ctrl_trans  
1676 B0BD D9 B0                 DC W:ext_reset                 ; reset device
1677 B0BF E4 B0                 DC W:ext_format                ; format device
1678 B0C1 ED B0                 DC W:ext_eject                 ; eject media
1679 B0C3 FB B0                 DC W:ext_set_dcb               ; set control parameters
1680 B0C5
1681 B0C5              *
1682 B0C5              * The following tables are the actual parameter lists referenced above.
1683 B0C5              * The first byte is the command number.  The parameter list starts at
1684 B0C5              * the second byte.
1685 B0C5                       export std_dev_stat
1686 B0C5 00           std_dev_stat DC B:$00                   ; status command
1687 B0C6 03                    DC B:$03                       ; pcnt
1688 B0C7 00                    DC B:$00                       ; unit number must come from DIB
1689 B0C8 00 AA                 DC W:sys_buffer                ; status list pointer
1690 B0CA 00                    DC B:$00                       ; status code is for device status
1691 B0CB
1692 B0CB                       export ext_dev_stat
1693 B0CB 40           ext_dev_stat DC B:$40                   ; status command
1694 B0CC 03                    DC B:$03                       ; pcnt
1695 B0CD 00                    DC B:$00                       ; unit number must come from DIB
1696 B0CE 00 AA 00 00           DC L:sys_buffer                ; status list pointer
1697 B0D2 00                    DC B:$00                       ; status code is for device status
1698 B0D3
1699 B0D3                       export std_reset
1700 B0D3 04           std_reset DC B:$04                      ; control command
1701 B0D4 03                    DC B:$03                       ; pcnt
1702 B0D5 00                    DC B:$00                       ; unit number must come from DIB
1703 B0D6 00 AA                 DC W:sys_buffer                ; status list pointer
1704 B0D8 00                    DC B:$00                       ; status code is for device status
1705 B0D9
1706 B0D9                       export ext_reset
1707 B0D9 40           ext_reset DC B:$40                      ; control command
1708 B0DA 03                    DC B:$03                       ; pcnt
1709 B0DB 00                    DC B:$00                       ; unit number must come from DIB
1710 B0DC 00 AA 00 00           DC L:sys_buffer                ; status list pointer
1711 B0E0 00                    DC B:$00                       ; status code is for device status
1712 B0E1
1713 B0E1                       export std_format
1714 B0E1 03           std_format DC B:$03                     ; format command
1715 B0E2 01                    DC B:$01                       ; pcnt
1716 B0E3 00                    DC B:$00                       ; unit number must come from DIB
1717 B0E4
1718 B0E4                       export ext_format
1719 B0E4 43           ext_format DC B:$43                     ; format command
1720 B0E5 01                    DC B:$01                       ; pcnt
1721 B0E6 00                    DC B:$00                       ; unit number must come from DIB
1722 B0E7
1723 B0E7                       export std_eject
1724 B0E7 04           std_eject DC B:$04                      ; control command
1725 B0E8 03                    DC B:$03                       ; pcnt
1726 B0E9 00                    DC B:$00                       ; unit number must come from DIB
1727 B0EA 00 AA                 DC W:sys_buffer                ; status list pointer
1728 B0EC 04                    DC B:$04                       ; status code is for eject
1729 B0ED
1730 B0ED                       export ext_eject
1731 B0ED 44           ext_eject DC B:$44                      ; control command
1732 B0EE 03                    DC B:$03                       ; pcnt
1733 B0EF 00                    DC B:$00                       ; unit number must come from DIB
1734 B0F0 00 AA 00 00           DC L:sys_buffer                ; status list pointer
1735 B0F4 04                    DC B:$04                       ; status code is for eject
1736 B0F5
1737 B0F5                       export std_set_dcb
1738 B0F5 04           std_set_dcb DC B:$04                    ; control command
1739 B0F6 03                    DC B:$03                       ; pcnt
1740 B0F7 00                    DC B:$00                       ; unit number must come from DIB
1741 B0F8 00 AA                 DC W:sys_buffer                ; status list pointer
1742 B0FA 01                    DC B:$01                       ; status code is for set DCB
1743 B0FB
1744 B0FB                       export ext_set_dcb
1745 B0FB 44           ext_set_dcb DC B:$44                    ; control command
1746 B0FC 03                    DC B:$03                       ; pcnt
1747 B0FD 00                    DC B:$00                       ; unit number must come from DIB
1748 B0FE 00 AA 00 00           DC L:sys_buffer                ; status list pointer
1749 B102 01                    DC B:$01                       ; status code is for set DCB
1750 B103
1751 B103              *
1752 B103              * The following tables are used to translate GS/OS driver
1753 B103              * call numbers into ProDOS block device call numbers.
1754 B103              *
1755 B103                       export pro_trans
1756 B103              pro_trans  
1757 B103 00                    DC B:$00                       ; startup -> status
1758 B104 00                    DC B:$00                       ; open    -> status
1759 B105 01                    DC B:$01                       ; read    -> read
1760 B106 02                    DC B:$02                       ; write   -> write
1761 B107 00                    DC B:$00                       ; close   -> status
1762 B108 00                    DC B:$00                       ; status  -> status
1763 B109 03                    DC B:$03                       ; control -> format
1764 B10A 00                    DC B:$00                       ; flush   -> status
1765 B10B 00                    DC B:$00                       ; shutdn  -> status
1766 B10C
1767 B10C                       endp 
1768 B10C                       EJECT 
1769 B10C              *****************************************************************
1770 B10C              *
1771 B10C              * The following routine copies data from the system buffer to
1772 B10C              * the buffer specified in the call parameter list.
1773 B10C              *
1774 B10C              * ENTRY:        A Reg = Error code from device
1775 B10C              *               X Reg = Unspecified
1776 B10C              *               Y Reg = Unspecified
1777 B10C              *               B Reg = Unspecified
1778 B10C              *             Dir Reg = GS/OS Direct Page
1779 B10C              *               P Reg = 16 bit 'm' & 'x'
1780 B10C              *                       c = 0 if no error from device
1781 B10C              *                       c = 1 if error from device
1782 B10C              *
1783 B10C              * EXIT:         A Reg = Unchanged
1784 B10C              *               X Reg = Unchanged
1785 B10C              *               Y Reg = Unchanged
1786 B10C              *               B Reg = Unchanged
1787 B10C              *             Dir Reg = Unchanged
1788 B10C              *               P Reg = Unchanged
1789 B10C              *
1790 B10C              *****************************************************************
1791 B10C                       export system_to_buf
1792 B10C              system_to_buf proc 
1793 B10C 38                    sec   
1794 B10D 80 01                 bra   buffer_xfer
1795 B10F
1796 B10F
1797 B10F                       EJECT 
1798 B10F              ****************************************************************
1799 B10F              *
1800 B10F              * This routine is used to transfer data from the buffer
1801 B10F              * specified in the parameter list to the system buffer.
1802 B10F              *
1803 B10F              * ENTRY:        A Reg = Unspecified
1804 B10F              *               X Reg = Unspecified
1805 B10F              *               Y Reg = Unspecified
1806 B10F              *               B Reg = Current Program Bank
1807 B10F              *             Dir Reg = GSOS Direct Page
1808 B10F              *               P Reg = 16 bit 'm' & 'x' native mode
1809 B10F              *
1810 B10F              * EXIT:         A Reg = Unspecified
1811 B10F              *               X Reg = Unspecified
1812 B10F              *               Y Reg = Unspecified
1813 B10F              *               B Reg = Current Program Bank
1814 B10F              *             Dir Reg = GSOS Direct Page
1815 B10F              *               P Reg = 16 bit 'm' & 'x' native mode
1816 B10F              *
1817 B10F              ****************************************************************
1818 B10F                       export buf_to_system
1819 B10F              buf_to_system               
1820 B10F                       longa on
1821 B10F                       longi on
1822 B10F
1823 B10F 18                    clc   
1824 B110              buffer_xfer  
1825 B110 08                    php   
1826 B111 48                    pha   
1827 B112 DA                    phx   
1828 B113 5A                    phy   
1829 B114 8B                    phb   
1830 B115
1831 B115 90 0C                 bcc   from_device
1832 B117
1833 B117 F4 00 00              pea   sys_buffer>>16           ; source is buffer
1834 B11A F4 00 AA              pea   sys_buffer
1835 B11D D4 06                 pei   <drvr_buf_ptr+2          ; destination is buffer
1836 B11F D4 04                 pei   <drvr_buf_ptr
1837 B121 80 0A                 bra   do_buf_xfer
1838 B123
1839 B123              from_device  
1840 B123 D4 06                 pei   <drvr_buf_ptr+2          ; source is buffer
1841 B125 D4 04                 pei   <drvr_buf_ptr
1842 B127 F4 00 00              pea   sys_buffer>>16           ; destination is buffer
1843 B12A F4 00 AA              pea   sys_buffer
1844 B12D
1845 B12D              do_buf_xfer  
1846 B12D F4 00 00              pea   $0000                    ; transfer count
1847 B130 D4 14                 pei   <drvr_blk_size
1848 B132 F4 05 08              pea   move_sinc_dinc           ; src incr & dest incr
1849 B135 22 70 FC 01           jsl   move_info                ; go do it to it
1850 B139 AB                    plb   
1851 B13A 7A                    ply   
1852 B13B FA                    plx   
1853 B13C 68                    pla   
1854 B13D 28                    plp   
1855 B13E 6B                    rtl   
1856 B13F
1857 B13F                       EJECT 
1858 B13F              *****************************************************************
1859 B13F              *
1860 B13F              * The following routine copies the contents of a block that
1861 B13F              * resides in the cache to the buffer specified by the driver
1862 B13F              * call.
1863 B13F              *
1864 B13F              * ENTRY:        A Reg = Unspecified
1865 B13F              *               X Reg = Unspecified
1866 B13F              *               Y Reg = Unspecified
1867 B13F              *               B Reg = Unspecified
1868 B13F              *             Dir Reg = GS/OS Direct Page
1869 B13F              *               P Reg = 16 bit 'm' & 'x'
1870 B13F              *
1871 B13F              * EXIT:         A Reg = Unspecified
1872 B13F              *               X Reg = Same as entry
1873 B13F              *               Y Reg = Unspecified
1874 B13F              *               B Reg = Same as entry
1875 B13F              *             Dir Reg = GS/OS Direct Page
1876 B13F              *               P Reg = 16 bit 'm' & 'x'
1877 B13F              *
1878 B13F              *****************************************************************
1879 B13F                       export cache_to_buff
1880 B13F              cache_to_buff  
1881 B13F D4 1E                 pei   <drvr_cach_ptr+2         ; source is buffer
1882 B141 D4 1C                 pei   <drvr_cach_ptr
1883 B143 D4 06                 pei   <drvr_buf_ptr+2          ; destination is buffer
1884 B145 D4 04                 pei   <drvr_buf_ptr
1885 B147 80 08                 bra   set_move_cnt             ; transfer count
1886 B149
1887 B149                       EJECT 
1888 B149              *****************************************************************
1889 B149              *
1890 B149              * The following routine copies the contents of a block that
1891 B149              * resides in the buffer specified by the driver call to the
1892 B149              * cache.
1893 B149              *
1894 B149              * ENTRY:        A Reg = Unspecified
1895 B149              *               X Reg = Unspecified
1896 B149              *               Y Reg = Unspecified
1897 B149              *               B Reg = Unspecified
1898 B149              *             Dir Reg = GS/OS Direct Page
1899 B149              *               P Reg = 16 bit 'm' & 'x'
1900 B149              *
1901 B149              * EXIT:         A Reg = Unspecified
1902 B149              *               X Reg = Same as entry
1903 B149              *               Y Reg = Unspecified
1904 B149              *               B Reg = Same as entry
1905 B149              *             Dir Reg = GS/OS Direct Page
1906 B149              *               P Reg = 16 bit 'm' & 'x'
1907 B149              *
1908 B149              *****************************************************************
1909 B149                       export buff_to_cache
1910 B149              buff_to_cache  
1911 B149 D4 06                 pei   <drvr_buf_ptr+2          ; source is buffer
1912 B14B D4 04                 pei   <drvr_buf_ptr
1913 B14D D4 1E                 pei   <drvr_cach_ptr+2         ; destination is buffer
1914 B14F D4 1C                 pei   <drvr_cach_ptr
1915 B151                       export set_move_cnt
1916 B151              set_move_cnt  
1917 B151 F4 00 00              pea   $0000                    ; transfer count
1918 B154 D4 14                 pei   <drvr_blk_size
1919 B156 F4 05 08              pea   move_sinc_dinc           ; src incr & dest incr
1920 B159 22 70 FC 01           jsl   move_info                ; go do it to it
1921 B15D 6B                    rtl   
1922 B15E
1923 B15E                       eject 
1924 B15E              *****************************************************************
1925 B15E              *
1926 B15E              * The following routine calls the system ID routine.  All
1927 B15E              * register outputs reflect the machine ID values returned from
1928 B15E              * the rom call except that the processor status will indicate
1929 B15E              * Z=0 if the rom version is $01.
1930 B15E              *
1931 B15E              * ENTRY:        A Reg = Unspecified
1932 B15E              *               X Reg = Unspecified
1933 B15E              *               Y Reg = Unspecified
1934 B15E              *               B Reg = Unspecified
1935 B15E              *             Dir Reg = GS/OS Direct Page
1936 B15E              *               P Reg = N V M X D I Z C  E
1937 B15E              *                       x x 0 0 0 x x x  0
1938 B15E              *
1939 B15E              * EXIT:         A Reg = Unspecified
1940 B15E              *               X Reg = Same as entry
1941 B15E              *               Y Reg = Unspecified
1942 B15E              *               B Reg = Same as entry
1943 B15E              *             Dir Reg = GS/OS Direct Page
1944 B15E              *               P Reg = N V M X D I Z C  E
1945 B15E              *                       x x 0 0 0 x 0 x  0 If not rom version 01
1946 B15E              *                       x x 0 0 0 x 1 x  0 If rom version 01
1947 B15E              *
1948 B15E              *****************************************************************
1949 B15E                       export machine_id
1950 B15E              machine_id  
1951 B15E                       longa on
1952 B15E                       longi on
1953 B15E
1954 B15E E2 20                 sep   #$20                     ; 8 bit 'm'
1955 B160                       longa off
1956 B160
1957 B160 AF 68 C0 00           lda   >statereg                ; preserve rom select
1958 B164 48                    pha   
1959 B165 09 08                 ora   #%00001000               ; and select the rom
1960 B167 8F 68 C0 00           sta   >statereg
1961 B16B
1962 B16B C2 20                 rep   #$20                     ; 16 bit 'm'
1963 B16D                       longa on
1964 B16D
1965 B16D 8B                    phb   
1966 B16E 4B                    phk   
1967 B16F AB                    plb   
1968 B170 38                    sec   
1969 B171 20 1F FE              jsr   $FE1F                    ; call monitor rom ID routine
1970 B174 AB                    plb   
1971 B175 EB                    xba   
1972 B176
1973 B176 E2 20                 sep   #$20                     ; 8 bit 'm'
1974 B178                       longa off
1975 B178
1976 B178 68                    pla                            ; restore rom selection
1977 B179 8F 68 C0 00           sta   >statereg
1978 B17D
1979 B17D C2 20                 rep   #$20                     ; 16 bit 'm'
1980 B17F                       longa on
1981 B17F
1982 B17F EB                    xba   
1983 B180 29 FF 00              and   #$00FF
1984 B183 C0 01 00              cpy   #$0001
1985 B186 6B                    rtl   
1986 B187
1987 B187                       endp 
1988 B187                       eject 
1989 B187              *****************************************************************
1990 B187              *
1991 B187              * This routine is used to dispatch to a routine in any
1992 B187              * language card space based on the LC MODE.
1993 B187              *
1994 B187              * ENTRY: Call via a 'JSL' instruction.....
1995 B187              *
1996 B187              *        Stack prior to 'JSL' is as follows:
1997 B187              *
1998 B187              *                       Byte            ; so address occupies a longword
1999 B187              *                       K               ; dispatch address
2000 B187              *                       PC              ; dispatch address
2001 B187              *                       LC MODE         ; word describing LC where:
2002 B187              *               SP --->                 ;     $0000 = LC bank 0
2003 B187              *                                       ;     $0001 = LC bank 1
2004 B187              *
2005 B187              *               A Reg = Undefined
2006 B187              *               X Reg = Undefined
2007 B187              *               Y Reg = Undefined
2008 B187              *               B Reg = Undefined
2009 B187              *             Dir Reg = Undefined
2010 B187              *               P Reg = N V M X D I Z C  E
2011 B187              *                       x x 0 0 0 x x    0
2012 B187              *                                     x     as set by caller
2013 B187              *
2014 B187              * AT DISPATCH TO ROUTINE IN LC:
2015 B187              *
2016 B187              *         Routine is called via a 'JSL' instruction.....
2017 B187              *
2018 B187              *               A Reg = Unchanged
2019 B187              *               X Reg = unchanged
2020 B187              *               Y Reg = unchanged
2021 B187              *               B Reg = unchanged
2022 B187              *             Dir Reg = unchanged
2023 B187              *               P Reg = N V M X D I Z C  E
2024 B187              *                       x x 0 0 0 x x    0
2025 B187              *                                     x     as set by caller
2026 B187              *
2027 B187              * EXIT:         A Reg = value returned from routine in LC
2028 B187              *               X Reg = value returned from routine in LC
2029 B187              *               Y Reg = value returned from routine in LC
2030 B187              *               B Reg = value returned from routine in LC
2031 B187              *             Dir Reg = value returned from routine in LC
2032 B187              *               P Reg = N V M X D I Z C  E
2033 B187              *                           0 0 0 x x    0
2034 B187              *                       x x                 based on value in A Reg
2035 B187              *                                        x  as set by routine that was called
2036 B187              *
2037 B187              *****************************************************************
2038 B187                       export lc_dispatcher
2039 B187              lc_dispatcher proc 
2040 B187                       longa on
2041 B187                       longi on
2042 B187
2043 B187              lc_bank  equ   1                        ; byte - current LC bank
2044 B187              dir_reg  equ   lc_bank+1                ; word - direct register on entry
2045 B187              a_reg    equ   dir_reg+2                ; word - accumulator on entry
2046 B187              ret_addr equ   a_reg+2                  ; addr - who called -1
2047 B187              lc_mode  equ   ret_addr+3               ; word - new LC bank
2048 B187              lc_addr  equ   lc_mode+2                ; long - address to dispatch to
2049 B187
2050 B187              *
2051 B187              * Change stack to direct page for easy manipulation of parameters
2052 B187              *
2053 B187 48                    pha                            ; save environment
2054 B188 0B                    phd   
2055 B189 E2 20                 sep   #$20                     ; 8 bit 'm'
2056 B18B                       longa off
2057 B18B AF 68 C0 00           lda   >statereg                ; set destination LC bank
2058 B18F 48                    pha   
2059 B190 3B                    tsc                            ; change stack into direct page
2060 B191 5B                    tcd   
2061 B192              *
2062 B192              * Move LC bank (bit 0 of input word) to bit 2 for hardware
2063 B192              * register manipulation.
2064 B192              *
2065 B192 A9 01                 lda   #%00000001               ; reconfigure mode word
2066 B194 25 09                 and   <lc_mode
2067 B196 08                    php   
2068 B197 0A                    asl   a
2069 B198 0A                    asl   a
2070 B199 28                    plp   
2071 B19A 85 09                 sta   <lc_mode
2072 B19C AF 68 C0 00           lda   >statereg
2073 B1A0 29 FB                 and   #%11111011
2074 B1A2 05 09                 ora   <lc_mode
2075 B1A4 8F 68 C0 00           sta   >statereg
2076 B1A8              *
2077 B1A8              * Preset dispatch address
2078 B1A8              *
2079 B1A8 A5 0D                 lda   <lc_addr+2
2080 B1AA 8F CA B1 00           sta   >lc_jump_addr+3
2081 B1AE C2 20                 rep   #$20                     ; 16 bit 'm'
2082 B1B0                       longa on
2083 B1B0 A5 0B                 lda   <lc_addr
2084 B1B2 8F C8 B1 00           sta   >lc_jump_addr+1
2085 B1B6              *
2086 B1B6              * Move parameters on stack for easy exit on return from LC.
2087 B1B6              *
2088 B1B6 DA                    phx   
2089 B1B7 A2 06 00              ldx   #$0006
2090 B1BA              clean_stack  
2091 B1BA B5 01                 lda   <lc_bank,x
2092 B1BC 95 07                 sta   <ret_addr+1,x
2093 B1BE CA                    dex   
2094 B1BF CA                    dex   
2095 B1C0 10 F8                 bpl   clean_stack
2096 B1C2 FA                    plx   
2097 B1C3
2098 B1C3 4B                    phk                            ; clean up stack for dispatch
2099 B1C4 68                    pla   
2100 B1C5 2B                    pld                            ; set registers for dispatch
2101 B1C6 68                    pla   
2102 B1C7              *
2103 B1C7              * Dispatch to function resident in LC.
2104 B1C7              *
2105 B1C7                       export lc_jump_addr
2106 B1C7              lc_jump_addr  
2107 B1C7 22 00 00 00           jsl   >$000000                 ; self modified to destination address
2108 B1CB C2 30                 rep   #$30                     ; make sure in 16 bit 'm' & 'x'
2109 B1CD                       longa on
2110 B1CD                       longi on
2111 B1CD 83 05                 sta   5,s                      ; save registers for return
2112 B1CF 7B                    tdc   
2113 B1D0 83 03                 sta   3,s
2114 B1D2 4B                    phk                            ; clean off remaining byte
2115 B1D3 68                    pla   
2116 B1D4 E2 20                 sep   #$20                     ; 8 bit 'm'
2117 B1D6                       longa off
2118 B1D6 68                    pla                            ; restore original LC
2119 B1D7 8F 68 C0 00           sta   >statereg
2120 B1DB C2 20                 rep   #$20                     ; 16 bit 'm'
2121 B1DD                       longa on
2122 B1DD 2B                    pld   
2123 B1DE 68                    pla   
2124 B1DF 6B                    rtl   
2125 B1E0
2126 B1E0                       endp 
2127 B1E0
2128 B1E0                       end   
